package pattern.client;

import java.util.Vector;
import pattern.message.Message;
import pattern.message.P2PMessage;
import pattern.server.ServerImpl;
import pattern.server.*;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.io.Serializable;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;

public class Client extends UnicastRemoteObject implements clientIF, Serializable
{
	private Server messageServer = null; // the clients reference to the ServerImpl..gotten with RMI
	public String myName;
	private Vector messageBuffer = new Vector(); // the messages the client sends out
	private Message lastMessage; // the last message the client received...just for demonsration purposes
	private int position = 0; //used to control the message buffer
	private int startPosition = 0;

	public Client( String name )  throws RemoteException //, ServerImpl server )
	{
		this.myName = name; //need to know where to send the message to.
	}

	public String getName()
	{
		return myName;
	}

	public void connect()
	{
		try 
		{ 
            messageServer = ( Server )Naming.lookup("//localhost:1099/MessageService"); 
			messageServer.acceptConnection( myName );
		} 
		catch ( Exception e ) 
		{ 
            System.out.println( "Message Server Exception: " + e.getMessage() ); 
            e.printStackTrace(); 
        }
	}

	public void acknowledge( Message m )
	{
		try
		{
			messageServer.acknowledge( m );	
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}
	}

	public void displayMessage( Message message )
	{
		if( lastMessage != null )
		{
			System.out.println( "======================================" );
			System.out.println( "The Message type is: " + lastMessage.getType() );
			System.out.println( "The Message contents are: " + lastMessage.getContents() );
			System.out.println( myName + "got message for " + lastMessage.getDestination() );
			System.out.println( "======================================" );
		}
		else
		{
			System.out.println( myName + " has never received a message" );
		}
	}

	public void sendMessage()
	{
		System.out.println( " Entered sendMessage " );
		Message mesToSend = getNextMessage();
		displayMessage( mesToSend );
		try
		{
			messageServer.acceptMessage( mesToSend );	
		}
		catch ( Exception e )
		{
			System.out.println( "This is where the trouble is " +  e.getMessage() );
		}
	}

	public void receiveMessage( Message message )
	{
		System.out.println( myName + " Received this message : " );
		try
		{
			lastMessage = message;
			displayMessage( lastMessage );
			acknowledge( message );
		}
		catch ( Exception e )
		{
			System.out.println( e.getMessage() );
		}
	}

	public void createMessage( String content, String destination )
	{
		P2PMessage mes = new P2PMessage( content, destination );

		try
		{
			addToBuffer( mes );
		}
		catch ( Exception e )
		{
			System.out.println( e.getMessage() );
		}
	}
	
	/*	Will get the size of the message buffer and add the 
		message in the corrent position
	*/
	public void addToBuffer( Message m )
	{
		System.out.println( myName + "Adding message to position " + position );
		messageBuffer.add( position, m );
		position ++;
	}
	
	/*  Gets the next message from the Message Buffer
	*/
	public Message getNextMessage()
	{
		System.out.println( "messageBuffer Vector size is : " + messageBuffer.size() );
		System.out.println( myName + "Removing Message from position " + startPosition );
		Message tempMessage = ( Message )messageBuffer.firstElement(); 
		messageBuffer.remove( tempMessage );
		return tempMessage;
	}

	//Needed to make the object Serializable
	private void writeObject( java.io.ObjectOutputStream out ) throws IOException{}
	
	private void readObject( java.io.ObjectInputStream in ) throws IOException, ClassNotFoundException{}

}