package pattern.client;


import pattern.client.*;
import pattern.message.*;
import pattern.server.*;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;

class Tester
{
	public static void main( String[] args ) 
	{
		//ServerImpl messageServer = new ServerImpl();
		//Add the Observer
		//Sender sender = new Sender( messageServer );
		// Create and install a security manager
		if ( System.getSecurityManager() == null ) 
		{
		    System.setSecurityManager( new RMISecurityManager() );
		}
	
		try 
		{
		    Client client1 = new Client ( "client_one" );
			Client client2 = new Client ( "client_two" );
			
		    // Bind this object instance to the name "MessageService"
		    Naming.rebind( "//localhost/" + "client_one", client1 );
			Naming.rebind( "//localhost/" + "client_two", client2 );
					
		    System.out.println( "Client1 and Client2 bound in registry" );

			client1.connect();
			client2.connect();

			client1.createMessage( "   Client One         Message One", "client_two" );
			client1.createMessage( "   Client One         Message Two", "client_two" );

			client1.sendMessage();
		} 
		catch ( Exception e ) 
		{
		    System.out.println( "Client error: " + e.getMessage() );
		    e.printStackTrace();
		}
		
		
		//client1.createMessage( "   Client One         Message One", "client_two" );
		//client1.sendMessage();
		/*client2.createMessage( "                      **** one ****", "client_one" );
		client1.createMessage( "   Client One         Message Two", "client_two" );
		client2.createMessage( "                      ***** two ****", "client_one" );
		client1.createMessage( "   Client One         Message Three", "client_two" );
		client2.createMessage( "                      ***** Three****", "client_one" );
		client1.createMessage( "   Client One         Message Four", "client_two" );
		client2.createMessage( "                      ***** Four *****", "client_one" );

		client1.sendMessage();
		client2.sendMessage();
		client1.sendMessage();
		client2.sendMessage();
		client1.sendMessage();
		client2.sendMessage(); */
		

		

	}
}

