
package pattern.server;

import java.util.Vector;
import pattern.client.*;
import pattern.message.Message;

public class Sender implements Observer 
{

	private ServerImpl server;

	public Sender( ServerImpl server )
	{
		this.server = server;
		server.addObserver( this );
	}

	public synchronized void update( Subject subject )
	{
		System.out.println( " Entered Observer Sender " );

		if( subject == server )
		{
			System.out.println( " the contents of the server have changed ");
			int numClients = server.connectedObjects.size();
			int numMessages = server.messageQueue.size();
			System.out.println( "numClients is : " + numClients );
			System.out.println( "numMessages is : " + numMessages );
			
			try
			{
				for ( int x = 0 ; x < numMessages ; x ++ )
				{
					Message m = ( Message ) server.messageQueue.remove( x );
					System.out.println( "\nCurrent message destination is :" + m.getDestination() );
					
					for ( int i = 0 ; i < numClients ; i ++ )
					{
						clientIF currentClient = ( clientIF )server.connectedObjects.get( i );
						System.out.println( "current clients name is:" + currentClient.getName() );
						
						if ( m.getDestination().equals( currentClient.getName() ) )
						{
							server.sendMessage( currentClient, m );
							break;
						}
					}
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}
	}
}

