
package pattern.server;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import pattern.message.Message;
import pattern.client.*;
import pattern.server.*;


public class ServerImpl extends UnicastRemoteObject implements Server,Subject
{

	public Vector connectedObjects = new Vector();  // keeps a record of the connected objects
	public Vector messageQueue = new Vector();      // vector to contain queued messages 
	public Vector ackedMessages  = new Vector();
	private Vector observers = new Vector();
	int numClientsConnected;
    
	//Constructor
	public ServerImpl() throws RemoteException 
	{
		super();
		numClientsConnected = 0;
	}
	
	public void acceptConnection( String client )
	{
		//System.out.println( "--------- > Entered server-acceptConnection   " );
		clientIF thisClient;
		try 
		{ 
            thisClient = ( clientIF ) Naming.lookup( "//localhost:1099/" + client ); 
			System.out.println( "Client " + thisClient.getName() + "connected" );
			connectedObjects.add( thisClient );	
			//System.out.println( " Got reference to Client " );
        } 
		catch ( Exception e ) 
		{ 
            System.out.println( "Message Server Exception: " + e.getMessage() ); 
            e.printStackTrace(); 
        }
		
		//System.out.println( "The number of connected Objects is now " + connectedObjects.size() );
	}
	
	public void acknowledge( Message message )
	{
		System.out.println( " Received Acknowledgement " );
		ackedMessages.add( message );
		notifyObservers();
	}

	public void acceptMessage( Message message )
	{
		//System.out.println( "Entered server-acceptMessage" );
				
		if ( message != null )
		{
			messageQueue.add( message );
			System.out.println( "the contents of the message to be sent are " + message.getContents() );
			notifyObservers();
		}
	}
	

	public void sendMessage( clientIF client, Message message )
	{	
		//System.out.println( "**************************" );
		System.out.println( "Server sent a Message" );
		try
		{
			client.receiveMessage( message );
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}
	}
		
		
			
	
	public void addObserver( Observer o )
	{
		observers.add( o );
		//System.out.println( "------------> Observer Added" );
	}

    public void removeObserver( Observer o ) 
	{
		observers.remove( o );
		//System.out.println( "------------> Observer Removed" );
    }		

	private void notifyObservers() 
	{
		System.out.println( " Entered Notify Observers " );

		int size = observers.size();

		for ( int i = 0 ; i < size ; i++ )
		{
			//System.out.println( "in notifyObservers and i is :" + i );
			Observer o = ( Observer ) observers.get( i );
			o.update( this );
        }		
	}

	public static void main( String args[] ) 
	{
		// Create and install a security manager
		if ( System.getSecurityManager() == null ) 
		{
		    System.setSecurityManager( new RMISecurityManager() );
		}
	
		try 
		{
		    ServerImpl messageServer = new ServerImpl();
			//Add the Observer
			Sender sender = new Sender( messageServer );
	
		    // Bind this object instance to the name "MessageService"
		    Naming.rebind( "//localhost/MessageService", messageServer );
	
		    System.out.println( "MessageServer bound in registry" );
		} 
		catch ( Exception e ) 
		{
		    System.out.println( "ServerImpl error: " + e.getMessage() );
		    e.printStackTrace();
		}
	}
}
	
	
	


