package pattern.client;

import java.util.Vector;
import pattern.message.Message;
import pattern.message.P2PMessage;
import pattern.server.ServerImpl;

public class Client
{
	private ServerImpl messageServer; // the clients reference to the ServerImpl..gotten with RMI
	public String myName;
	private Vector messageBuffer = new Vector(); // the messages the client sends out
	private Message lastMessage; // the last message the client received...just for demonsration purposes
	private int position = 0; //used to control the message buffer
	private int startPosition = 0;

	public Client( String name, ServerImpl server )
	{
		this.myName = name; //need to know where to send the message to.
		this.messageServer = server;
		connect();
	}

	public String getName()
	{
		return myName;
	}

	public void connect()
	{
		messageServer.acceptConnection( this );
	}

	public void acknowledge( Message m )
	{
		messageServer.acknowledge( m );
	}

	public void displayLastMessage()
	{
		if( lastMessage != null )
		{
			System.out.println( "The Message type is: " + lastMessage.getType() );
			System.out.println( "The Message contents are: " + lastMessage.getContents() );
			System.out.println( myName + "got message for " + lastMessage.getDestination() );
		}
		else
		{
			System.out.println( myName + " has never received a message" );
		}
	}

	public void sendMessage()
	{
		System.out.println( myName + " sending message" );
			
		try
		{
			messageServer.acceptMessage( getNextMessage() );	
		}
		catch ( Exception e )
		{
			System.out.println( "This is where the trouble is " +  e.getMessage() );
		}
	}

	public void receiveMessage( Message m)
	{
		System.out.println( "**************************" );
		System.out.println( myName + " receiving message " );
		
		try
		{
			lastMessage = m;
			displayLastMessage();
			acknowledge( m );
		}
		catch ( Exception e )
		{
			System.out.println( e.getMessage() );
		}
	}

	//will send a message to this client
	public void createMessage()
	{
		P2PMessage mes = new P2PMessage( "System Testing Message", myName );

		try
		{
			addToBuffer( mes );
		}
		catch ( Exception e )
		{
			System.out.println( e.getMessage() );
		}
	}

	//method overloaded in order to test sends to other clients.
	public void createMessage( String content, String destination )
	{
		P2PMessage mes = new P2PMessage( content, destination );

		try
		{
			addToBuffer( mes );
		}
		catch ( Exception e )
		{
			System.out.println( e.getMessage() );
		}
	}
	
	/*	Will get the size of the message buffer and add the 
		message in the corrent position
	*/
	public void addToBuffer( Message m )
	{
		//position = messageBuffer.size();
		System.out.println( myName + "Adding message to position " + position );
		messageBuffer.add( position, m );
		position ++;
	}
	
	/*  Gets the next message from the Message Buffer
	*/
	public Message getNextMessage()
	{
		System.out.println( "messageBuffer Vector size is : " + messageBuffer.size() );
		System.out.println( myName + "Removing Message from position " + startPosition );
		Message tempMessage = ( Message )messageBuffer.firstElement(); 
		messageBuffer.remove( tempMessage );
		return tempMessage;
	}
}