package pattern.message;


/**
  *	 Extend Message for each Messaging Domain. Only Point to Point implemented in this project.
  *  
  *  
  */

import java.io.Serializable;
import java.io.IOException;

public abstract class Message implements Serializable
{
	protected String content;
	protected int type;    // Point to Point or Publish Subscribe 
	 	
	public abstract String getDestination();
	
	public abstract String getState();
		
	// Returns the type P2PMessage == 1 and PUBSUBMessage == 0	
	public int getType()
	{
		return type;
	}

	// Returns the message contents
	public String getContents()
	{
		return content;
	}
	
	//Needed to make the object Serializable
	private void writeObject( java.io.ObjectOutputStream out ) throws IOException
	{
	}
	
	private void readObject( java.io.ObjectInputStream in ) throws IOException, ClassNotFoundException
	{
	}

}