package pattern.message;


import java.io.Serializable;
import java.io.IOException;

/* Point to Point message, differ from Publish Subscribe Message
   in that it only has one destination, i.e only one client will 
   receive this message only once. Publish Subscribe messaging is beyond 
   the scope of this project as it would be very complicated to implement.
*/
public class P2PMessage extends Message
{
	private String destination; //String containing the Clients unique name
	private String state = "not_sent";

	public P2PMessage( String content, String destination )
	{
		this.type = 1; //type has to be one as it's a P2P Message
		this.content = content;
		this.destination = destination;
	}
	
	// Returns the Messages destination
	public String getDestination()
	{
		return destination;
	}

	// Whether or not the message has been not sent,sent or acknowledged
	public String getState()
	{
		return state;
	}

	// can set the message as been received
	public void setState( String new_state )
	{
		this.state = new_state;
	}
			
}