
package pattern.server;

import java.util.Vector;
import pattern.message.Message;
import pattern.client.Client;

public class ServerImpl implements Subject
			
			
{

	public Vector connectedObjects = new Vector();  // keeps a record of the connected objects
	public Vector messageQueue = new Vector();      // vector to contain queued messages 
	public Vector ackedMessages  = new Vector();
	private Vector observers = new Vector();
	int numClientsConnected;
    
	//Constructor
	public ServerImpl() 
	{
		numClientsConnected = 0;
	}
	
	public void acceptConnection( Client client )
	{
		//System.out.println( "--------- > Entered server-acceptConnection" );
		connectedObjects.add( client );
		//System.out.println( "The number of connected Objects is now " + connectedObjects.size() );
	}
	
	public void acknowledge( Message message )
	{
		System.out.println( " Received Acknowledgement " );
		ackedMessages.add( message );
		notifyObservers();
	}

	public void acceptMessage( Message message )
	{
		//System.out.println( "Entered server-acceptMessage" );
				
		if ( message != null )
		{
			messageQueue.add( message );
			//System.out.println( message.getContents() );
			notifyObservers();
		}
	}
	

	public void sendMessage( Client client, Message message )
	{	
		//System.out.println( "**************************" );
		System.out.println( "Server sent a Message" );
		client.receiveMessage( message );
	
	}
		
		
			
	
	public void addObserver( Observer o )
	{
		observers.add( o );
		//System.out.println( "------------> Observer Added" );
	}

    public void removeObserver( Observer o ) 
	{
		observers.remove( o );
		//System.out.println( "------------> Observer Removed" );
    }		

	private void notifyObservers() 
	{
		System.out.println( " Entered Notify Observers " );

		int size = observers.size();

		for ( int i = 0 ; i < size ; i++ )
		{
			//System.out.println( "in notifyObservers and i is :" + i );
			Observer o = ( Observer ) observers.get( i );
			o.update( this );
        }		
	}
	
}
	
	
	


