/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 12, 2002
 * Time: 11:41:15 AM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp;

public class NNTPCommands
{

    /*
    Status codes:
    1xx - Informative message
      2xx - Command ok
      3xx - Command ok so far, send the rest of it.
      4xx - Command was correct, but couldn't be performed for
            some reason.
      5xx - Command unimplemented, or incorrect, or a serious
            program error occurred.

   The next digit in the code indicates the function response category.

      x0x - Connection, setup, and miscellaneous messages
      x1x - Newsgroup selection
      x2x - Article selection
      x3x - Distribution functions
      x4x - Posting
      x8x - Nonstandard (private implementation) extensions
      x9x - Debugging output

      */



    /*Display the header, a blank line, then the body (text) of the
   specified article.  Message-id is the message id of an article as
   shown in that article's header.  It is anticipated that the client
   will obtain the message-id from a list provided by the NEWNEWS
   command, from references contained within another article, or from
   the message-id provided in the response to some other commands.*/
    public String ARTICLE = "ARTICLE <mesg-id>";

    /*Displays the header, a blank line, then the body (text) of the
   current or specified article.  The optional parameter nnn is the

   numeric id of an article in the current newsgroup and must be chosen
   from the range of articles provided when the newsgroup was selected.
   If it is omitted, the current article is assumed.*/
    public String ARTICLE2 = "ARTICLE [nnn]";


    /*Responses to above:

    220 n <a> article retrieved - head and body follow
           (n = article number, <a> = message-id)
   221 n <a> article retrieved - head follows
   222 n <a> article retrieved - body follows
   223 n <a> article retrieved - request text separately
   412 no newsgroup has been selected
   420 no current article has been selected
   423 no such article number in this group
   430 no such article found
   */



    /*The required parameter ggg is the name of the newsgroup to be
   selected (e.g. "net.news").  A list of valid newsgroups may be
   obtained from the LIST command.

   The successful selection response will return the article numbers of
   the first and last articles in the group, and an estimate of the
   number of articles on file in the group.  It is not necessary that
   the estimate be correct, although that is helpful; it must only be
   equal to or larger than the actual number of articles on file.  (Some
   implementations will actually count the number of articles on file.
   Others will just subtract first article number from last to get an
   estimate.)*/

    public String GROUP = "GROUP ggg";

    /*Responses:
    211 n f l s group selected
            (n = estimated number of articles in group,
            f = first article number in the group,
            l = last article number in the group,
            s = name of the group.)
    411 no such news group */


    public String HELP = "HELP";
    /*3.3.2.  Responses

   100 help text follows */

    /*The IHAVE command informs the server that the client has an article
   whose id is <messageid>.  If the server desires a copy of that
   article, it will return a response instructing the client to send the
   entire article.  If the server does not want the article (if, for
   example, the server already has a copy of it), a response indicating
   that the article is not wanted will be returned.*/
    public String IHAVE = "IHAVE <messageid>";

    /*Responses:  235 article transferred ok
   335 send article to be transferred.  End with <CR-LF>.<CR-LF>
   435 article not wanted - do not send it
   436 transfer failed - try again later
   437 article rejected - do not try again*/


    /*The internally maintained "current article pointer" is set to the
   previous article in the current newsgroup.  If already positioned at
   the first article of the newsgroup, an error message is returned and
   the current article remains selected.

   The internally-maintained "current article pointer" is set by this
   command.*/
    public String LAST = "LAST";
    /*Responses:   223 n a article retrieved - request text separately
            (n = article number, a = unique article id)
    412 no newsgroup selected
    420 no current article has been selected
    422 no previous article in this group */




    /*Returns a list of valid newsgroups and associated information.  Each
   newsgroup is sent as a line of text in the following format:

      group last first p

   where <group> is the name of the newsgroup, <last> is the number of
   the last known article currently in that newsgroup, <first> is the
   number of the first article currently in the newsgroup, and <p> is
   either 'y' or 'n' indicating whether posting to this newsgroup is
   allowed ('y') or prohibited ('n').

   The <first> and <last> fields will always be numeric.  They may have
     leading zeros.  If the <last> field evaluates to less than the
     <first> field, there are no articles currently on file in the
     newsgroup.

    */
    public String LIST = "LIST";


    /*A list of newsgroups created since <date and time> will be listed in
    the same format as the LIST command"*/
    public String NEWSGROUPS = " NEWGROUPS date time [GMT] [<distributions>]";


    /*The internally maintained "current article pointer" is advanced to
    the next article in the current newsgroup.  If no more articles
    remain in the current group, an error message is returned and the
    current article remains selected.*/
    public String NEXT = "NEXT";

    /* 223 n a article retrieved - request text separately
           (n = article number, a = unique article id)
   412 no newsgroup selected
   420 no current article has been selected
   421 no next article in this group */


    public String POST = "POST";
    /*If posting is allowed, response code 340 is returned to indicate that
       the article to be posted should be sent. Response code 440 indicates
       that posting is prohibited for some installation-dependent reason.

       If posting is permitted, the article should be presented in the
       format specified by RFC850, and should include all required header
       lines. After the article's header and body have been completely sent
       by the client to the server, a further response code will be returned
       to indicate success or failure of the posting attempt.

       The text forming the header and body of the message to be posted
       should be sent by the client using the conventions for text received
       from the news server:  A single period (".") on a line indicates the
       end of the text, with lines starting with a period in the original
       text having that period doubled during transmission.

       No attempt shall be made by the server to filter characters, fold or
       limit lines, or otherwise process incoming text.  It is our intent
       that the server just pass the incoming message to be posted to the
       server installation's news posting software, which is separate from
       this specification.  See RFC850 for more details.

       Since most installations will want the client news program to allow
       the user to prepare his message using some sort of text editor, and
       transmit it to the server for posting only after it is composed, the
       client program should take note of the herald message that greeted it
       when the connection was first established. This message indicates
       whether postings from that client are permitted or not, and can be
       used to caution the user that his access is read-only if that is the
       case. This will prevent the user from wasting a good deal of time
       composing a message only to find posting of the message was denied.
       The method and determination of which clients and hosts may post is
       installation dependent and is not covered by this specification.

        Responses:
        240 article posted ok
        340 send article to be posted. End with <CR-LF>.<CR-LF>
        440 posting not allowed
        441 posting failed

        */

    /*
    4.1.  Example 1 - relative access with NEXT

       S:      (listens at TCP port 119)

       C:      (requests connection on TCP port 119)
       S:      200 wombatvax news server ready - posting ok

       (client asks for a current newsgroup list)
       C:      LIST
       S:      215 list of newsgroups follows
       S:      net.wombats 00543 00501 y
       S:      net.unix-wizards 10125 10011 y
               (more information here)
       S:      net.idiots 00100 00001 n
       S:      .

       (client selects a newsgroup)
       C:      GROUP net.unix-wizards
       S:      211 104 10011 10125 net.unix-wizards group selected
               (there are 104 articles on file, from 10011 to 10125)

       (client selects an article to read)
       C:      STAT 10110
       S:      223 10110 <23445@sdcsvax.ARPA> article retrieved - statistics
               only (article 10110 selected, its message-id is
               <23445@sdcsvax.ARPA>)

       (client examines the header)
       C:      HEAD
       S:      221 10110 <23445@sdcsvax.ARPA> article retrieved - head
               follows (text of the header appears here)
       S:      .

       (client wants to see the text body of the article)
       C:      BODY
       S:      222 10110 <23445@sdcsvax.ARPA> article retrieved - body
               follows (body text here)
       S:      .

       (client selects next article in group)


       ///POSTING ----------------

       S:      (listens at TCP port 119)

   C:      (requests connection on TCP port 119)
   S:      200 BANZAIVAX news server ready, posting allowed.

   C:      POST
   S:      340 Continue posting; Period on a line by itself to end
   C:      (transmits news article in RFC850 format)
   C:      .
   S:      240 Article posted successfully.

   C:      QUIT
   S:      205 BANZAIVAX closing connection.  Goodbye.

       */


}
