/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 12, 2002
 * Time: 3:40:22 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.commands;


public abstract class AbstractNNTPCommand implements NNTPCommandIfc, Runnable
{
    protected String COMMAND = "";
    protected int _responseCode = 0;
    protected String _responseContent = null;
    protected String _lastError = null;
    private String _args = "";
    
    protected int CONTINUE_RECEIVING = 0;
	protected int STOP_CONVERSATION = 1;
    

    public boolean sendCommand(NNTPCommandIfc parentCommand)
    {
		CommandProcessor.getInstance().performSubCommand(parentCommand, this);
		return true;
    }
    
    public boolean sendCommand()
    {
		CommandProcessor.getInstance().performCommand(this);
        return true;
    }

    public void run()
    {
        try
        {
            sendCommand();
            processContent();
        }
        catch (Exception e)
        {
            System.out.println("EX1: " + e);
            e.printStackTrace(System.out);
        }

    }

    public int getResponseCode()
    {
        return _responseCode;
    }

    public String getContent()
    {
        return _responseContent;
    }
    
	public void setContent(String content)
	{
		_responseContent = content;
	}
	

    public String getLastError()
    {
        return _lastError;
    }

    public void setLastError(String error)
    {
        _lastError = error;
    }

    public void setCommandArguments(String args)
    {
        _args = args;
    }

    public String getCommandArguments()
    {
        return _args;
    }
    
	public boolean continueProcessingAction(int serverResponseCode)
	{
		return true;	
	}
	
	public void setResponseCode(int code)
	{
		_responseCode = code;
	}
    
	public boolean isAtomicCommand()
	{
		return true;
	}
	
	public void returnSocket()
	{
		
	  CommandProcessor.getInstance().returnSocket(this);	
	}
	
	public int peformActionForReponseCode(int responseCode)
	{
		return CONTINUE_RECEIVING;
	}
}
