/*
 * Created on Dec 17, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.daveconcannon.nntp.commands;
import java.util.Hashtable;
import java.net.Socket;
import com.daveconcannon.nntp.io.*;
import java.io.*;
import com.daveconcannon.nntp.NNTPResponseCodes;

public class CommandProcessor 
{
	private static CommandProcessor _instance = null;
	private Hashtable _commandToConnectionMap = null;
	public static final String CR_LF_PAIR = "\r\n";	
	
	private CommandProcessor()
	{
		_commandToConnectionMap = new Hashtable();	
	}
	
	
	public static CommandProcessor getInstance()
	{
		if(_instance == null)
		{
			_instance = new CommandProcessor();
		}
		return _instance;		
	}
	
	
	private void setConnectionForCommand(Socket s, NNTPCommandIfc command)
	{
		if(s != null && command != null)
		{
			_commandToConnectionMap.put(s, command);
			_commandToConnectionMap.put(command, s);
		}
	}
	
	private Socket getConnectionForCommand(NNTPCommandIfc command)
	{
		return (Socket)_commandToConnectionMap.get(command);
	}
	
	private NNTPCommandIfc getCommandForConnection(Socket connection)
	{
		return (NNTPCommandIfc)_commandToConnectionMap.get(connection);
	}
	
	
	public void performCommand(NNTPCommandIfc command)
	{
		if(sendCommand(command))
		{
			String content = getServerResponse(command);
			command.setContent(content);
		}
		else
		{
			Logger.getInstance().log("Not continuting with command");
		}
		
		if(command.isAtomicCommand())
		{
			returnSocket(command);
		}
	}
	
	public void performSubCommand(NNTPCommandIfc parentCommand, NNTPCommandIfc subCommand)
	{
		Socket socket = getConnectionForCommand(parentCommand);
		String commandString = subCommand.getCommand();
		if(subCommand.getCommandArguments() != null && !"".equals(subCommand.getCommandArguments()))
		{
			commandString += " " + subCommand.getCommandArguments();
		}
		commandString += CR_LF_PAIR;
		
		if(socket == null)
		{
			socket = NNTPIOPool.getInstance().getFreeSocket();
		}
		
		if(sendCommand(commandString, socket))
		{
			setConnectionForCommand(socket, subCommand);
			String content = getServerResponse(subCommand);
			subCommand.setContent(content);
		}
	}
	
	public void returnSocket(NNTPCommandIfc command)
	{
		Socket s = (Socket)_commandToConnectionMap.remove(command);
		if(s != null)
		{
			_commandToConnectionMap.remove(s);
			NNTPIOPool.getInstance().returnSocket(s);
		}
	}
	
	public void clearIntialStream(BufferedReader in, DataOutputStream out)
	{
		try
		{
			out.writeBytes(CR_LF_PAIR);
			in.readLine();
		}
		catch (Exception e)
		{
			
		}
	}
	
	public void performSpecificCommand(String commandString, NNTPCommandIfc command)
	{
		//System.out.println("Perform specific: \""+commandString+"\"");
		Socket socket = getConnectionForCommand(command);
		if(socket == null)
		{
			socket = NNTPIOPool.getInstance().getFreeSocket();
			setConnectionForCommand(socket, command);
		}
		
		if(sendCommand(commandString, socket))
		{
			String content = getServerResponse(command);
			command.setContent(content);
		}

		if(command.isAtomicCommand())
		{
			returnSocket(command);
		}
	}
	
	private boolean sendCommand(String commandString, Socket socket)
	{   
		Logger.getInstance().log("Sending Command: \"" + commandString +"\"Socket: \""+socket.hashCode()+"\"");
		try
  	    {
			   boolean needsClearing = false;
			   BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
			   DataOutputStream out = new DataOutputStream(socket.getOutputStream());				   
			   ByteArrayOutputStream byteArray = new ByteArrayOutputStream(1024);
			   if(NNTPIOPool.getInstance().socketNeedsClearing(socket))
			   {
				   clearIntialStream(in, out);
				   NNTPIOPool.getInstance().setCleared(socket);
			   }
		
			   byteArray.reset();
			   byteArray.write(commandString.getBytes());
			   out.writeBytes(byteArray.toString("UTF8"));
			   out.flush();
			   return true;
		  }
		  catch (Exception e)
		  {
			Logger.getInstance().log("Exception: "+e);
			Logger.getInstance().log(e);
		  }
		
		return false;
	}
	
	
	private String _lastCommand = null;
	private boolean sendCommand(NNTPCommandIfc command)
	{
	   String commandString = command.getCommand();
	   
	   if(command.getCommandArguments() != null && !"".equals(command.getCommandArguments()))
	   {
	   		commandString += " " + command.getCommandArguments();
	   }
	   
	   commandString += CR_LF_PAIR;
	   _lastCommand = commandString;   
	   try
	   {
	   		boolean needsClearing = false;
	   		Socket socket = getConnectionForCommand(command);
	   		BufferedReader in = null;
	   		DataOutputStream out = null;
		    ByteArrayOutputStream byteArray = new ByteArrayOutputStream(1024);
	   		if(socket == null || socket.isClosed())
	   		{
	   			socket = NNTPIOPool.getInstance().getFreeSocket();
				setConnectionForCommand(socket, command);
	   		}
	   		
			return sendCommand(commandString, socket);
	   }
	   catch (Exception e)
	   {
		   Logger.getInstance().log(e);
		   command.setLastError("Error sending command");
	   }
	   
	   return false;
	}
	
	
	private String getServerResponse(NNTPCommandIfc command)
	{
		Object[] response = new Object[2];
		int responseCode = -1;
		StringBuffer responseString = new StringBuffer();
		String s = "";
		try
		{
			Socket socket = getConnectionForCommand(command);
			BufferedReader in = null;
			DataOutputStream out = null;
			ByteArrayOutputStream byteArray = new ByteArrayOutputStream(1024);
			if(socket == null || socket.isClosed())
			{
				socket = NNTPIOPool.getInstance().getFreeSocket();
				setConnectionForCommand(socket, command);
			}
			
			in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
			out = new DataOutputStream(socket.getOutputStream());
			// The response code is the first three chars.
			s = in.readLine();
			if(s == null)
			{
				return "500";
			}
			
			boolean continueParsing = true;

			if (command instanceof NNTPGroupCommand)
			{
				continueParsing = false;
			}

			if (s != null && s.length() == 3)
			{
				responseCode = Integer.parseInt(s);
			}
			else
			{
				char[] charArray = new char[3];
				if (s != null && s.length() > 2)
				{
					s.getChars(0, 3, charArray, 0);
					responseCode = Integer.parseInt(new String(charArray));
					responseString.append(s.substring(3, s.length()));
					//responseString.append(s);
				}
				else
				{
					responseCode = NNTPResponseCodes.COMMAND_NOT_RECOGNISED;
				}
			}
			command.setResponseCode(responseCode);
			
			String claz = command.getClass().toString();
			Logger.getInstance().log("Got response: \""+responseCode+"\" on socket:\""+socket.hashCode()+"\" - " + 
			claz.substring(claz.lastIndexOf("."), claz.length()));
			
			int[] errorCodes = command.getErrorCodes();
			for (int i = 0; i < errorCodes.length; i++)
			{
				int code = errorCodes[i];
				if (responseCode == code)
				{
					Logger.getInstance().log("Non-critical Error code returned: " + responseCode + " Error: " + responseString);
					command.setLastError("Non-critical Error code returned: " + responseCode + " Error: " + responseString);
					return responseString.toString();//response;
				}
			}

			if (responseCode == NNTPResponseCodes.COMMAND_NOT_RECOGNISED ||
				responseCode == NNTPResponseCodes.COMMAND_SYNTAX_ERROR)
			{
				Logger.getInstance().log("Received a error response code from the newsgroup.: \"" + responseCode + "\",  " +
						responseString + ", Command: \""+_lastCommand+"\"");
				command.setLastError("Received a error response code from the newsgroup.: \"" + responseCode + "\",  " +
						responseString);
				
				return responseString.toString();//response;
			}

			//if (continueParsing)
			
			if(command.continueProcessingAction(responseCode))
			{
				while (!".".equals(s))
				{
					s = in.readLine();
					responseString.append(s + "\n");
				}
			}

			//response[0] = new Integer(responseCode);
			//response[1] = responseString.toString();
		}
		catch (IOException e)
		{
			Logger.getInstance().log("IO Exception: " + e);
			command.setLastError(e.getMessage());
		}
		catch (NumberFormatException nfe)
		{
			Logger.getInstance().log("Number format Exception: " + nfe);
			command.setLastError(nfe.getMessage());
		}
        

		return responseString.toString();	
	}

}
