/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 12, 2002
 * Time: 3:28:02 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.commands;

import com.daveconcannon.nntp.objects.NNTPArticle;
import com.daveconcannon.nntp.objects.NNTPArticleIfc;
import com.daveconcannon.nntp.objects.NNTPObjectIfc;

import java.util.Iterator;
import java.util.StringTokenizer;

public class NNTPArticleCommand extends AbstractNNTPCommand
{

    public static int ARTICLE_RETRIEVED = 220;// n <a> article retrieved - head and body follow
    //(n = article number, <a> = message-id)
    public static int ARTICLE_RETRIEVED_HEAD_FOLLOWS = 221;// n <a> article retrieved - head follows
    public static int ARTICLE_RETRIEVED_BODY_FOLLOWS = 222;// n <a> article retrieved - body follows
    public static int ARTICLE_RETRIEVED_REQ_TEXT_SEPERATELY = 223;// n <a> article retrieved - request text separately
    public static int NO_NEWSGROUP_SELECTED = 412;// no newsgroup has been selected
    public static int NO_ARTICLE_SELECTED = 420;// no current article has been selected
    public static int NO_SUCH_ARTICLE_IN_GROUP = 423;//  423 no such article number in this group
    public static int NO_SUCH_ARTICLE = 430;// no such article found

    protected String COMMAND = "ARTICLE"; // Only populate by headers, not the full content.
	private static final String ARTICLE_RETRIEVED_RESPONSE = "article retrieved - head and body follows";

    public NNTPArticleCommand()
    {
    }

    public boolean sendCommand()
    {
    	if(getCommandArguments() == null)
    	{
	        throw new IllegalArgumentException("Article command requires an article ID as an argument");
    	}
		
		return super.sendCommand();
    }

    NNTPArticleIfc _currentArticle = null;

	private boolean _isPostContent = false;
	private void populateHead(StringTokenizer tokenizer)
	{
		boolean isXRef = false;

		while (tokenizer.hasMoreTokens())
		{
			String token = tokenizer.nextToken();

			if (_isPostContent)
			{
				return;
			}

			if (!":".equals(token) && !"\n".equals(token))
			{
				for (Iterator i = NNTPArticle._attributeList.iterator(); i.hasNext();)
				{
					String attrKey = (String) i.next();
					if (token.trim().startsWith(attrKey))
					{
						String attribute = "";

						if (token.equals(attrKey))
						{
							// Grab the next two tokens.
							if (tokenizer.hasMoreTokens())
							{
								attribute += tokenizer.nextToken("\n");
							}
						}
						else
						{
							if(token.length() > (attrKey.length() + 2))
							{
								attribute = token.substring(attrKey.length() + 2);
							}
							
							attribute = attribute.replace((char) 13, (char) 32);
						}

						//System.out.println("Setting attribute: \""+attrKey+"\", \""+attribute.trim()+"\"");
						_currentArticle.setAttribute(attrKey, attribute.trim());

						if (NNTPArticle.ATTR_OP_X_REF.equals(token) ||
								token.startsWith(NNTPArticle.ATTR_OP_X_REF))
						{
							_isPostContent = true;
							isXRef = true;
						}
						else if ((NNTPArticle.ATTR_OP_X_CACHE.equals(token) ||
								token.startsWith(NNTPArticle.ATTR_OP_X_CACHE)) || isXRef)
						{
							_isPostContent = true;
						}
					}
				}
			}
		}
		
		setCommandArguments("");
	}
	
	private void populateBody(StringTokenizer tokenizer)
	{
		String postContents = "";

		while (tokenizer.hasMoreTokens())
		{
			String nextContent = tokenizer.nextToken();
			if(!".".equals(nextContent))	
			{
				postContents += nextContent;
			}
		}

		_currentArticle.setAttribute(NNTPArticleIfc.ATTR_POST_CONTENT, postContents);
		_isPostContent = false;
	}
		
    public void processContent()
    {
        _currentArticle = new NNTPArticle();

        if (getContent() == null)
        {
            return;
        }
		
		String content = getContent();
		if(getResponseCode() == ARTICLE_RETRIEVED || 
		   getResponseCode() == ARTICLE_RETRIEVED_HEAD_FOLLOWS)
		{
			int ind = 0;
			if((ind = content.indexOf(ARTICLE_RETRIEVED_RESPONSE)) != -1)
			{
				content = content.substring(ind + ARTICLE_RETRIEVED_RESPONSE.length(), content.length());
			}
			
		}
		StringTokenizer tokenizer = new StringTokenizer(content, "\n", true);
		populateHead(tokenizer);
		  
		if(getResponseCode() == ARTICLE_RETRIEVED_BODY_FOLLOWS ||
		  (getResponseCode() == ARTICLE_RETRIEVED && _isPostContent))
  	    {
			  populateBody(tokenizer);
		}
    }

    public NNTPObjectIfc getProcessedContent()
    {
        if (_currentArticle == null)
        {
            throw new IllegalStateException("You need to populate the article using processContent() first!");
        }
        return _currentArticle;
    }

    public String getCommand()
    {
        return COMMAND;
    }

    public int[] getErrorCodes()
    {
        return new int[]
        {
            NO_NEWSGROUP_SELECTED,
            NO_ARTICLE_SELECTED,
            NO_SUCH_ARTICLE,
            NO_SUCH_ARTICLE_IN_GROUP
        };
    }
}
