/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 23, 2002
 * Time: 10:56:31 AM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.commands;

import java.util.ArrayList;

public class NNTPCommandChannell
{
    private static NNTPCommandChannell _instance = null;
    private ArrayList _queue = null;
    private Object _mutex = new Object();


    private NNTPCommandChannell()
    {
        _queue = new ArrayList();
    }


    public void put(Runnable r)
    {

        synchronized (_mutex)
        {
            _queue.add(r);
        }
    }

    public Runnable get()
    {
        Runnable r = null;
        if (_queue.isEmpty())
        {
            return r;
        }

        synchronized (_mutex)
        {
            r = (Runnable) _queue.get(_queue.size() - 1);
            _queue.remove(r);
        }

        return r;
    }

    public static NNTPCommandChannell getInstance()
    {
        if (_instance == null)
        {
            _instance = new NNTPCommandChannell();
        }

        return _instance;
    }


}
