/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 23, 2002
 * Time: 10:48:38 AM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.commands;

public class NNTPCommandQueue
{
    private static NNTPCommandQueue _instance = null;
    private NNTPCommandChannell _queue = null;

    private NNTPCommandQueue()
    {
        _queue = NNTPCommandChannell.getInstance();
        processQueue();
    }


    public static NNTPCommandQueue getInstance()
    {
        if (_instance == null)
        {
            _instance = new NNTPCommandQueue();
        }

        return _instance;
    }


    protected void processQueue()
    {
        Runnable runner = new Runnable()
        {
            public void run()
            {
                try
                {
                    while (true)
                    {
                        Runnable r = _queue.get();
                        if (r != null)
                        {
                            r.run();
                        }
                    }
                }
                catch (Exception e)
                {
					System.out.println("Exception in command queue " + e);
                }
            }
        };

        new Thread(runner).start();
    }


    public void execute(Runnable r)
    {
        try
        {
            _queue.put(r);
        }
        catch (Exception e)
        {
			System.out.println("Exception : " + e);
            Thread.currentThread().interrupt();
        }
    }


}
