/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 12, 2002
 * Time: 3:28:02 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.commands;

import com.daveconcannon.nntp.objects.NNTPGroupIfc;
import com.daveconcannon.nntp.objects.NNTPObjectIfc;
import com.daveconcannon.nntp.objects.NNTPArticleIfc;
import com.daveconcannon.nntp.objects.NNTPGroupContainer;

import java.util.StringTokenizer;

public class NNTPGroupCommand extends AbstractNNTPCommand
{
    /*211 n f l s group selected
           (n = estimated number of articles in group,
           f = first article number in the group,
           l = last article number in the group,
           s = name of the group.)
   411 no such news group */

    public static int NO_SUCH_NEWSGROUP = 411;
    public static final int GROUP_SELECTED = 211;
	public static final int GROUP_SELECTED_HEAD_FOLLOWS = 221;
	
    private String _groupName = null;
	private NNTPHeadCommand _headCommand = null;
    private NNTPGroupIfc _currentGroup = null;
    protected String COMMAND = "GROUP";

    public NNTPGroupCommand()
    {
    	_headCommand = new NNTPHeadCommand();
    }

    public boolean sendCommand(String command)
    {
        _groupName = command;
        setCommandArguments(_groupName);
        return super.sendCommand();
    }

	public boolean selectGroup(NNTPGroupIfc group)
	{	
		return sendCommand(group.getName());
	}

    /* (n = estimated number of articles in group,
           f = first article number in the group,
           l = last article number in the group,
           s = name of the group.)
     */
     
    public void processContent(NNTPGroupIfc group)
    {
     	_currentGroup = group;
     	processContent();
     	_currentGroup = null;
    }
    
    public synchronized void processContent()
    {
        String content = getContent();

        if(content == null || "".equals(content))
        {
			returnSocket();
        	return;
        }
        
        if(getResponseCode() == GROUP_SELECTED || getResponseCode() == GROUP_SELECTED_HEAD_FOLLOWS)
        {
	        //System.out.println("Content for group command: "+content +" , Code:"+getResponseCode());
	        StringTokenizer tokenizer = new StringTokenizer(content, "\r\f\n ", false);
	        while (tokenizer.hasMoreTokens())
	        {
	            String numberOfArticles = tokenizer.nextToken();
	            String first = tokenizer.nextToken();
	            String last = tokenizer.nextToken();
	            _groupName = tokenizer.nextToken();
	            
	            // Discard "selected" string.
	            String y = tokenizer.nextToken();
	
	            try
	            {
	            	int numArticles = Integer.parseInt(numberOfArticles);
	                int firstArticle = Integer.parseInt(first);
	                int lastArticle = Integer.parseInt(last);
	                if(_currentGroup == null)
	                {
	                	_currentGroup = NNTPGroupContainer.getInstance().getGroup(_groupName);
	                }
	                
					NNTPGroupContainer.getInstance().setCurrentSelectedGroup(_currentGroup);
	                
	                int previousLast = _currentGroup.getLastArticle();
	                if(_currentGroup.getArticleList().size() < numArticles) 
	                {
	                	previousLast = firstArticle;
	                }
	                
	                _currentGroup.setFirstArticle(firstArticle);
	                _currentGroup.setLastArticle(lastArticle);
	                
	                
	                // Populate all unseen articles...
	                for (int i = firstArticle; i != lastArticle+1; i++)
	                {
						NNTPArticleIfc article = _currentGroup.getArticle(i);
						if(article != null)
						{
							continue;
						}
						
						_headCommand.setCommandArguments(String.valueOf(i));
						_headCommand.setCurrentGroup(_currentGroup);
	                    
	                    boolean successful = _headCommand.sendCommand(this);
	                    if(!successful ||
						_headCommand.getResponseCode() == NNTPHeadCommand.NO_SUCH_ARTICLE || 
						_headCommand.getResponseCode() == NNTPHeadCommand.NO_SUCH_ARTICLE_IN_GROUP)
	                    {
	                        System.out.println("No such article: \""+i+"\"");
	                    }
	                    else
	                    {
							_headCommand.processContent();
	                        article = (NNTPArticleIfc)_headCommand.getProcessedContent();
	                        article.setArticleArrayId(i);
	                        article.setFullyPopulated(false);
	                        _currentGroup.addArticle(article);
	                    }
	                }



	                NNTPGroupContainer.getInstance().addGroup(_currentGroup);
	            }
	            catch (NumberFormatException e)
	            {
	                //System.out.println("Number format in group");
	            }
	        }
        }
        returnSocket();
        setCommandArguments("");
	}
    

    public NNTPObjectIfc getProcessedContent()
    {
        if (_currentGroup == null)
        {
            throw new IllegalStateException("You need to populate the group using ProcessContent() first!");
        }

        return _currentGroup;
    }

    public String getCommand()
    {
        return COMMAND;
    }

    public int[] getErrorCodes()
    {
        return new int[]
        {
            NO_SUCH_NEWSGROUP
        };
    }
    
	public boolean continueProcessingAction(int serverResponseCode)
	{
		// Don't continue for group command, there's no more info.
		// Tis a one-line response.
		return false;	
	}
	
	public boolean isAtomicCommand()
	{
		return false;
	}
	

}
