/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 12, 2002
 * Time: 3:28:02 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.commands;

import com.daveconcannon.nntp.objects.NNTPArticleFactory;
import com.daveconcannon.nntp.objects.NNTPArticleIfc;
import com.daveconcannon.nntp.objects.NNTPArticle;
import com.daveconcannon.nntp.objects.NNTPGroupIfc;
import com.daveconcannon.nntp.objects.NNTPObjectIfc;

import java.util.Iterator;
import java.util.StringTokenizer;

public class NNTPHeadCommand extends AbstractNNTPCommand
{
    private NNTPGroupIfc _group = null;

    public static int ARTICLE_RETRIEVED = 220;// n <a> article retrieved - head and body follow
    //(n = article number, <a> = message-id)
    public static int ARTICLE_RETRIEVED_HEAD_FOLLOWS = 221;// n <a> article retrieved - head follows
    public static int ARTICLE_RETRIEVED_BODY_FOLLOWS = 222;// n <a> article retrieved - body follows
    public static int ARTICLE_RETRIEVED_REQ_TEXT_SEPERATELY = 223;// n <a> article retrieved - request text separately
    public static int NO_NEWSGROUP_SELECTED = 412;// no newsgroup has been selected
    public static int NO_ARTICLE_SELECTED = 420;// no current article has been selected
    public static int NO_SUCH_ARTICLE_IN_GROUP = 423;//  423 no such article number in this group
    public static int NO_SUCH_ARTICLE = 430;// no such article found
	private static final String ARTICLE_HEAD_RETRIEVED_RESPONSE = "article retrieved - head follows";
	private static final String ARTICLE_BODY_RETRIEVED_RESPONSE = "article retrieved - body follows";
	
    protected String COMMAND = "HEAD"; // Only populate by headers, not the full content.

    public NNTPHeadCommand()
    {
    }

    NNTPArticleIfc _currentArticle = null;

    public void processContent()
    {
        _currentArticle = NNTPArticleFactory.getInstance().createArticle();
		
		
        if (getContent() == null)
        {
            return;
        }

		
		String content = getContent();
		int ind = 0;
		if((ind = content.indexOf(ARTICLE_HEAD_RETRIEVED_RESPONSE)) != -1)
		{
			content = content.substring(ind + ARTICLE_HEAD_RETRIEVED_RESPONSE.length(), content.length());
		}
		else if((ind = content.indexOf(ARTICLE_BODY_RETRIEVED_RESPONSE)) != -1)
		{
			content = content.substring(ind + ARTICLE_BODY_RETRIEVED_RESPONSE.length(), content.length());
		}
		if(getResponseCode() == NO_SUCH_ARTICLE_IN_GROUP ||
		   getResponseCode() == NO_SUCH_ARTICLE)
		{
			return;
		}
		
        StringTokenizer tokenizer = new StringTokenizer(content, "\n", true);
        boolean isPostContent = false;
        boolean isXRef = false;

        while (tokenizer.hasMoreTokens())
        {
            String token = tokenizer.nextToken();

            if (isPostContent)
            {
                String postContents = "";
                while (tokenizer.hasMoreTokens())
                {
                    postContents += tokenizer.nextToken();
                }

                _currentArticle.setAttribute(NNTPArticleIfc.ATTR_POST_CONTENT, postContents);

            }

            if (!":".equals(token) && !"\n".equals(token))
            {
                for (Iterator i = NNTPArticle._attributeList.iterator(); i.hasNext();)
                {
                    String attrKey = (String) i.next();
                    if (token.trim().startsWith(attrKey))
                    {
                        String attribute = "";

                        if (token.equals(attrKey))
                        {
                            // Grab the next two tokens.
                            if (tokenizer.hasMoreTokens())
                            {
                                attribute += tokenizer.nextToken("\n");
                            }
                        }
                        else
                        {
							if(token.length() > attrKey.length() + 2)
							{
								attribute = token.substring(attrKey.length() + 2);
							}
                            
                            attribute = attribute.replace((char) 13, (char) 32);
                        }

                        _currentArticle.setAttribute(attrKey, attribute.trim());

                        if (NNTPArticle.ATTR_OP_X_REF.equals(token) ||
                                token.startsWith(NNTPArticle.ATTR_OP_X_REF))
                        {
                            isXRef = true;
                        }

                        if ((NNTPArticle.ATTR_OP_X_CACHE.equals(token) ||
                                token.startsWith(NNTPArticle.ATTR_OP_X_CACHE)) && isXRef)
                        {
                            isPostContent = true;
                        }
                    }
                }
            }
        }

       _currentArticle.setFullyPopulated(false);       
        setCommandArguments("");
    }

    public NNTPObjectIfc getProcessedContent()
    {
        if (_currentArticle == null)
        {
            throw new IllegalStateException("You need to populate the article using processContent() first!");
        }
        return _currentArticle;
    }

    public String getCommand()
    {
        return COMMAND;
    }

    public int[] getErrorCodes()
    {
        return new int[]
        {
            NO_NEWSGROUP_SELECTED,
            NO_ARTICLE_SELECTED,
            NO_SUCH_ARTICLE,
            NO_SUCH_ARTICLE_IN_GROUP
        };
    }

    public void setCurrentGroup(NNTPGroupIfc group)
    {
        _group = group;
    }
}
