/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 12, 2002
 * Time: 3:28:02 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.commands;

import com.daveconcannon.nntp.objects.NNTPGroup;
import com.daveconcannon.nntp.objects.NNTPGroupContainer;
import com.daveconcannon.nntp.objects.NNTPGroupIfc;
import com.daveconcannon.nntp.objects.NNTPObjectIfc;


import java.util.StringTokenizer;

public class NNTPListCommand extends AbstractNNTPCommand
{
    private static int LAST_ARTICLE_NUMBER = 0;
    private static int FIRST_ARTICLE_NUMBER = 1;
    private static int POSTING_ENABLED = 2;

    public static int LIST_FOLLOWS_CODE = 215;
    protected String COMMAND = "LIST";
    
	private static String LIST_FOLLOWS_STRING = "list of newsgroups follows";

    public NNTPListCommand()
    {
    }

    public void processContent()
    {
        //System.out.println("List command, processing content.");
        if (getResponseCode() == LIST_FOLLOWS_CODE)
        {
            String content = getContent();
 
            if(content.indexOf(LIST_FOLLOWS_STRING) != -1)	
            {
				content = content.substring(content.indexOf(LIST_FOLLOWS_STRING)+
											LIST_FOLLOWS_STRING.length(),
											content.length());
            }
			StringTokenizer tokenizer = new StringTokenizer(content, "\r\f\n ", false);            
            while (tokenizer.hasMoreTokens())
            {
                
                String groupName = tokenizer.nextToken();
                if (".".equals(groupName))
                {
                    // We're finished!
                    return;
                }

				
                String last = tokenizer.nextToken();
                String first = tokenizer.nextToken();
                String postingEnabled = tokenizer.nextToken();

				//System.out.println("Name: " +groupName +" ,Last: "+last  +" , first: "+first+", enabled:"+postingEnabled);
				
                try
                {
                    Integer lastArticle = new Integer(Integer.parseInt(last));
                    Integer firstArticle = new Integer(Integer.parseInt(first));
                    boolean posting = "y".equals(postingEnabled);

                    NNTPGroupIfc group = NNTPGroupContainer.getInstance().getGroup(groupName);
                    if (group == null || ! group.isFullyPopulated() || 
                    	NNTPGroupContainer.getInstance().isRefreshing())
                    {
                        if(group == null)
                        {
							group = new NNTPGroup(groupName);
                        }

                        group.setFirstArticle(firstArticle.intValue());
                        group.setLastArticle(lastArticle.intValue());
                        group.setPostingEnabled(posting);      
                        group.setNeedsRefresh();                 
						NNTPGroupContainer.getInstance().addGroup(group);
                    }
                }
                catch (NumberFormatException e)
                {
                }
            }
        }
        else
        {
            System.out.println("List: Did not get the correct response code from the server.");
        }
    }

    public NNTPObjectIfc getProcessedContent()
    {
    	
        return NNTPGroupContainer.getInstance();
    }

    public String getCommand()
    {
        return COMMAND;
    }

    public int[] getErrorCodes()
    {
        return new int[0]; // No error codes for this command;
    }
}
