/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 12, 2002
 * Time: 3:28:02 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.commands;

import com.daveconcannon.nntp.objects.NNTPObjectIfc;
import com.daveconcannon.nntp.objects.NNTPArticleIfc;
import com.daveconcannon.nntp.objects.NNTPArticle;

import java.util.Map;
import java.util.Iterator;

public class NNTPPostCommand extends AbstractNNTPCommand
{
    public static int SEND_ARTICLE_TO_BE_POSTED = 340; // send article to be posted. End with <CR-LF>.<CR-LF>
    public static int ARTICLE_POSTED_OK = 240; // article posted ok
    public static int POSTING_NOT_ALLOWED = 440; // posting not allowed
    public static int POSTING_FAILED = 441; // posting failed
	
	private String RECOMMENDED_ID = "Ok, recommended ID ";
    protected String COMMAND = "POST";
	private String _postedMessageID = null;
	private boolean _commandArgumentsSet = false;
	
    public NNTPPostCommand()
    {
		_postedMessageID = "";
    }

 	public boolean sendCommand()
 	{
 		return true;
 	}

	/* (n = estimated number of articles in group,
           f = first article number in the group,
           l = last article number in the group,
           s = name of the group.)
     */
    public synchronized void processContent()
    {
		if(!_commandArgumentsSet)
		{
			returnSocket();
			throw new IllegalStateException("No information passed to post command");
		}

		CommandProcessor.getInstance().performSpecificCommand(COMMAND + CommandProcessor.CR_LF_PAIR, this);

		if(getResponseCode() == SEND_ARTICLE_TO_BE_POSTED)
		{
			String content = getContent();
			String id = content.substring(content.indexOf(RECOMMENDED_ID) + RECOMMENDED_ID.length(), content.length());
			setPostedMessageID(id);
			CommandProcessor.getInstance().performSpecificCommand(getCommandArguments(), this);
		}
		
		returnSocket();
    }
    
    public void setCommandArguments(Map attribs)
    {
		String seperator = ": ";
		String commandContent = "";
		for(Iterator i = NNTPArticle._attributeList.iterator();i.hasNext();)
		{
				String attribute = (String)i.next();
				String value = (String)attribs.get(attribute);
				if(value != null && ! "".equals(value))
				{
					commandContent += attribute + seperator + value +"\n";					
				}
		}

		commandContent += CommandProcessor.CR_LF_PAIR + CommandProcessor.CR_LF_PAIR;
		commandContent += (String)attribs.get(NNTPArticleIfc.ATTR_POST_CONTENT);
		commandContent += CommandProcessor.CR_LF_PAIR + "." + CommandProcessor.CR_LF_PAIR;
	  	setCommandArguments(commandContent);
		
		_commandArgumentsSet = true;
    }

	private void setPostedMessageID(String ID)
	{
		_postedMessageID = ID;	
	}
	public String getPostedMessageID()
	{
		return _postedMessageID;
	}

    public boolean isAtomicCommand()
    {
    	return false;
    }
    
    public NNTPObjectIfc getProcessedContent()
    {
        return null;
    }

    public String getCommand()
    {
        return COMMAND;
    }

    public int[] getErrorCodes()
    {
        return new int[]
        {
            SEND_ARTICLE_TO_BE_POSTED, // These two aren't error codes, but require no further IO stuff.
            ARTICLE_POSTED_OK,
            POSTING_NOT_ALLOWED,
            POSTING_FAILED
        };
    }
}
