/*
 * Created on Dec 19, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.daveconcannon.nntp.io;

import java.io.*;

public class Logger 
{
	private static Logger _instance = null;
	private String _errorLogPath = null;
	public static boolean DEBUG = false;
	
	private PrintWriter _output = null;
	
	private Logger()
	{
		_errorLogPath = com.daveconcannon.nntp.servlet.NNTPControlServlet.
										 _props.getProperty("error.log");
		
		System.out.println("Error log path: "+_errorLogPath);
		if(_errorLogPath == null || "".equals(_errorLogPath))
		{
			_errorLogPath = "NN_errors.log";
		}
		
		try
		{
			_output = new PrintWriter(new FileOutputStream(new File(_errorLogPath), true));
		}
		catch(Exception e)
		{}
	}
	
		public static Logger getInstance()
	{
		if(_instance == null)
		{
			_instance = new Logger();
		}
		
		return _instance;
	}
	
	public void log(Exception e)
	{
		e.printStackTrace(System.out);
		if(_output != null)
		{
			e.printStackTrace(_output);
		}
	}
	
	public void log(String log)
	{
		if(!DEBUG)
		{
			return;
		}
		String l = "[ -  \""+log+"\" - ]";
		System.out.println(l);
		if(_output != null)
		{
			_output.println(l);
			_output.flush();
		}
	}
}
