/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 17, 2002
 * Time: 4:44:35 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.io;

import java.net.Socket;
import java.util.*;

import com.daveconcannon.nntp.servlet.NNTPControlServlet;

public class NNTPIOPool
{

    private static NNTPIOPool _instance = null;
    private List _freeSockets = null;
    private Map _usedSockets = null;
    private int INITIAL_STREAMS_SIZE = 2;

    private static String _serverHost = "127.0.0.1";
    private static int _NNTPport = 119;
    //private NNTPSocketWrapper _wrapper = null;
    private NNTPIOPool()
    {
		_serverHost = NNTPControlServlet._props.getProperty("server.host");
		if(_serverHost == null || "".equals(_serverHost))
		{
			_serverHost = "127.0.0.1";
		}
		
        _freeSockets = new ArrayList();
        _usedSockets = new HashMap();
        initializePool(INITIAL_STREAMS_SIZE);
    }


    private void initializePool(int size)
    {
        NNTPSocketWrapper wrapper = null;
        for (int i = 0; i < size; i++)
        {
            try
            {
                wrapper = new NNTPSocketWrapper(_serverHost, _NNTPport);
                //System.out.println("\t ** CREATED SOCKET: "+wrapper.socketHash());
            }
            catch (Exception e)
            {
            	Logger.getInstance().log("Socket creation error. ");
            	Logger.getInstance().log(e);
            }

            if (wrapper != null)
            {
                _freeSockets.add(wrapper);
            }
        }
    }

    public static NNTPIOPool getInstance()
    {
        if (_instance == null)
        {
            _instance = new NNTPIOPool();
        }

        return _instance;
    }

    public Socket getFreeSocket()
    {
    	for (Iterator i = _freeSockets.iterator(); i.hasNext();)
        {
            NNTPSocketWrapper outputStream = (NNTPSocketWrapper) i.next();
            if (!outputStream.isGrabbed())
            {
                _freeSockets.remove(outputStream);
                Socket s = outputStream.grab();
                if(s.isClosed())
                {
                	try
                	{
                		outputStream.refresh();		
                	}
                	catch(Exception e)
                	{
                	}
                	s = outputStream.grab();
                }
                
                _usedSockets.put(s, outputStream);
                return s;
            }
        }

        return null;
    }
    
    
    public void setCleared(Socket s)
    {
		NNTPSocketWrapper wrapper = (NNTPSocketWrapper) _usedSockets.get(s);
		wrapper.setHasBeenCleared();
    }
    
    public boolean socketNeedsClearing(Socket s)
    {
		NNTPSocketWrapper wrapper = (NNTPSocketWrapper) _usedSockets.get(s);
		return wrapper!= null && !wrapper.hasBeenCleared();
    }

    public void returnSocket(Socket s)
    {
        NNTPSocketWrapper wrapper = (NNTPSocketWrapper) _usedSockets.remove(s);
        if(wrapper != null)
        {
        	wrapper.free(); 
        	_freeSockets.add(wrapper);
    	}
    }
    
    public static void main(String[] args)
    {
    	NNTPIOPool n = NNTPIOPool.getInstance();
    	Socket s = n.getFreeSocket();
    	System.out.println("S is: "+s);
    }
}
