/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 12, 2002
 * Time: 3:41:19 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.io;

import com.daveconcannon.nntp.NNTPResponseCodes;
import com.daveconcannon.nntp.commands.NNTPCommandIfc;
import com.daveconcannon.nntp.commands.NNTPGroupCommand;

import java.io.*;
import java.net.Socket;

public class NNTPIOSystem
{
    public static final int RESPONSE_CODE = 0;
    public static final int RESPONSE_CONTENT = 1;

    public static final String CR_LF_PAIR = "\r\n";
    
    private Object[] _serverResponse = null;
    private NNTPCommandIfc _currentCommand = null;

    private static NNTPIOSystem _instance = null;
    private Socket _connection = null;
    private BufferedReader _in = null;
    private DataOutputStream _out = null;
    private ByteArrayOutputStream _byteArray = new ByteArrayOutputStream(1024);
	
	private boolean inited = false;
    private NNTPIOSystem()
    {
		_connection = NNTPIOPool.getInstance().getFreeSocket();
		System.out.println("Got connection: "+_connection);
    }

	public static NNTPIOSystem getInstance()
	{
		if(_instance == null)
		{
			_instance = new NNTPIOSystem();
			_instance.initializeStreams();	
		}
		
		return _instance;
	
	}
    private void initializeStreams()
    {
        try
        {
            _in = new BufferedReader(new InputStreamReader(_connection.getInputStream()));
            _out = new DataOutputStream(_connection.getOutputStream());
			
            clearIntialStream();
        }
        catch (IOException ioe)
        {
            System.out.println("Error initialising streams.");
        }
    }

    public void sendCommand(String command, NNTPCommandIfc currentCommand)
    {
        command += CR_LF_PAIR;

        _currentCommand = currentCommand;

        try
        {
            _byteArray.reset();
            _byteArray.write(command.getBytes());
            _out.writeBytes(_byteArray.toString("UTF8"));
            _out.flush();
        }
        catch (Exception e)
        {
        	System.out.println("Exception: "+e);
        	e.printStackTrace(System.out);
            _currentCommand.setLastError("Error sending command");
        }

        _serverResponse = collectServerResponse();
    }

    public Object[] getServerResponse()
    {
        return _serverResponse;
    }

    public void clearIntialStream()
    {
        try
        {
            _out.writeBytes(CR_LF_PAIR);
            _in.readLine();
        }
        catch (Exception e)
        {
        }
    }

    private Object[] collectServerResponse()
    {
        Object[] response = new Object[2];
        int responseCode = -1;
        StringBuffer responseString = new StringBuffer();
        String s = null;
        try
        {
            // The response code is the first three chars.
            s = _in.readLine();
			//System.out.println("Server response: \""+s+"\"");
			
            boolean continueParsing = true;

            if (_currentCommand instanceof NNTPGroupCommand)
            {
                continueParsing = false;
            }

            if (s.length() == 3)
            {
                responseCode = Integer.parseInt(s);
            }
            else
            {
                char[] charArray = new char[3];
                if (s != null && s.length() > 2)
                {
                    s.getChars(0, 3, charArray, 0);
                    responseCode = Integer.parseInt(new String(charArray));
                    responseString.append(s.substring(3, s.length()));
                }
                else
                {
                    responseCode = NNTPResponseCodes.COMMAND_NOT_RECOGNISED;
                }
            }

            int[] errorCodes = _currentCommand.getErrorCodes();
            for (int i = 0; i < errorCodes.length; i++)
            {
                int code = errorCodes[i];
                if (responseCode == code)
                {
                    System.out.println("Non-critical Error code returned: " + responseCode + " Error: " + responseString);
                    _currentCommand.setLastError("Non-critical Error code returned: " + responseCode + " Error: " + responseString);
                    return response;
                }
            }

            if (responseCode == NNTPResponseCodes.COMMAND_NOT_RECOGNISED ||
                responseCode == NNTPResponseCodes.COMMAND_SYNTAX_ERROR)
            {
                 System.out.println("Received a error response code from the newsgroup.: \"" + responseCode + "\",  " +
                        responseString);
                _currentCommand.setLastError("Received a error response code from the newsgroup.: \"" + responseCode + "\",  " +
                        responseString);
                return response;
            }

            if (continueParsing)
            {
                while (!".".equals(s))
                {
                    s = _in.readLine();
                    //System.out.println("More response: \""+s+"\"");
                    responseString.append(s + "\n");
                }
            }

            response[0] = new Integer(responseCode);
            response[1] = responseString.toString();
        }
        catch (IOException e)
        {
            System.out.println("IO Exception: " + e);
            _currentCommand.setLastError(e.getMessage());
        }
        catch (NumberFormatException nfe)
        {
            System.out.println("Number format Exception: " + nfe);
            _currentCommand.setLastError(nfe.getMessage());
        }
        

        return response;
    }

    public void returnStreams()
    {
        //NNTPIOPool.getInstance().returnSocket(_connection);
    }
}
