/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 18, 2002
 * Time: 3:55:53 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.io;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class NNTPSocketWrapper
{
    private boolean _isGrabbed = false;
    private Socket _socket = null;
    private int _port = 0;
    private String _host = null;

    public NNTPSocketWrapper(Socket s)
    {
        _socket = s;
        _port = _socket.getPort();
        
        _host = _socket.getRemoteSocketAddress().toString();
		System.out.println("Host is:"+_host);
    }

    public NNTPSocketWrapper(String host, int port) throws UnknownHostException, IOException
    {
		_port = port;
		_host = host;
        _socket = new Socket(_host, _port);
        
    }

    public boolean isGrabbed()
    {
        return _isGrabbed;
    }

    public Socket grab()
    {
        _isGrabbed = true;
        return _socket;
    }

    public void free()
    {
        _isGrabbed = false;
        try
        {
            _socket.getOutputStream().flush();
        }
        catch (Exception e)
        {
        }
    }
    
    private boolean _hasBeenCleared = false;
    
    public void setHasBeenCleared()
    {
    	_hasBeenCleared = true;
    }
    public boolean hasBeenCleared()
    {
    	return _hasBeenCleared;
    }
    
    public void refresh()  throws UnknownHostException, IOException
    {
		System.out.println("\t ** Refreshing socket ** ");
		_socket = new Socket(_host, _port);
    }
    
    public int socketHash()
    {
    	return _socket.hashCode();
    }
    
}
