/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 16, 2002
 * Time: 11:24:31 AM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Collections;
import java.util.StringTokenizer;

public class NNTPArticle extends NNTPObject implements NNTPArticleIfc
{
    public static List _attributeList = new ArrayList();
    private boolean _hasBeenRead = false;
    private int _threadTab = 0;
    private List _references = null;
    private int _arrayId = -1;

	static 
	{
		_attributeList.add(ATTR_DATE);
		_attributeList.add(ATTR_FROM);
		_attributeList.add(ATTR_LINES);
		_attributeList.add(ATTR_MESG_ID);
		_attributeList.add(ATTR_NEWSGROUPS);
		_attributeList.add(ATTR_OP_CONTROL);
		_attributeList.add(ATTR_OP_DATE_RECIEVED);
		_attributeList.add(ATTR_OP_DISTRIBUTION);
		_attributeList.add(ATTR_OP_EXPIRES);
		_attributeList.add(ATTR_OP_FOLLOWUP_TO);
		_attributeList.add(ATTR_OP_ORGANIZATION);
		_attributeList.add(ATTR_OP_REFERENCES);
		_attributeList.add(ATTR_OP_REPLY_TO);
		_attributeList.add(ATTR_OP_SENDER);
		_attributeList.add(ATTR_PATH);
		_attributeList.add(ATTR_POSTING_VERSION);
		_attributeList.add(ATTR_RELAY_VERSION);
		_attributeList.add(ATTR_SUBJECT);
		_attributeList.add(ATTR_OP_XTRACE);
		_attributeList.add(ATTR_OP_X_CACHE);
		_attributeList.add(ATTR_OP_X_COMPLAINTS_TO);
		_attributeList.add(ATTR_OP_X_REF);
		_attributeList.add(ATTR_OP_NNTP_POSTING_DATE);
		_attributeList.add(ATTR_OP_CACHE_POST_PATH);
		_attributeList.add(ATTR_OP_NNTP_POSTING_HOST);
		
		
	}
    public NNTPArticle()
    {
    }


    public void markAsRead()
    {
        _hasBeenRead = true;
    }

    public boolean hasBeenRead()
    {
        return _hasBeenRead;
    }

    public List getReferences()
    {
        if (_references == null)
        {
            _references = new ArrayList();
            String refs = getAttribute(ATTR_OP_REFERENCES);
            if (refs != null && !"".equals(refs))
            {
                StringTokenizer tokeni = new StringTokenizer(refs, " ");
                while (tokeni.hasMoreTokens())
                {
                    String o = tokeni.nextToken();
                    _references.add(o);
                }
            }
        }

        return _references;
    }

    public void setAttribute(String key, String attribute)
    {
        super.setAttribute(key, attribute);

        if (ATTR_MESG_ID.equals(key))
        {
            setName(attribute);
        }
    }

    public List getGroupNames()
    {
        List groupNames = new ArrayList();
        if(getAttribute(ATTR_NEWSGROUPS) != null)
        {
        
	        StringTokenizer t = new StringTokenizer(getAttribute(ATTR_NEWSGROUPS), ",");
	        while (t.hasMoreElements())
	        {
	            groupNames.add(t.nextToken());
	        }
        }

        return groupNames;
    }


    public String getRelayVersion()
    {
        return getAttribute(NNTPArticleIfc.ATTR_RELAY_VERSION);
    }


    public String getPostingVersion()
    {
        return getAttribute(NNTPArticleIfc.ATTR_POSTING_VERSION);
    }


    public String getFrom()
    {
        return getAttribute(NNTPArticleIfc.ATTR_FROM);
    }

    public String getDate()
    {
        return getAttribute(NNTPArticleIfc.ATTR_DATE);
    }

    public String getNewsgroups()
    {
        return getAttribute(NNTPArticleIfc.ATTR_NEWSGROUPS);
    }

    public String getSubject()
    {
        return getAttribute(NNTPArticleIfc.ATTR_SUBJECT);
    }

    public String getId()
    {
        return getAttribute(NNTPArticleIfc.ATTR_MESG_ID);
    }

    public String getPath()
    {
        return getAttribute(NNTPArticleIfc.ATTR_PATH);
    }

    public String getNumberOfLines()
    {
        return getAttribute(NNTPArticleIfc.ATTR_LINES);
    }

    public String getFollowupTo()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_FOLLOWUP_TO);
    }

    public String getDateReceived()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_DATE_RECIEVED);
    }

    public String getExpires()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_EXPIRES);
    }

    public String getReplyTo()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_REPLY_TO);
    }

    public String getSender()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_SENDER);
    }

    public String getControl()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_CONTROL);
    }

    public String getDistribution()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_DISTRIBUTION);
    }

    public String getOrganization()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_ORGANIZATION);
    }

    public String getXTrace()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_XTRACE);
    }

    public String getXComplaints()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_X_COMPLAINTS_TO);
    }

    public String getNNTPPostingDate()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_NNTP_POSTING_DATE);
    }

    public String getNNTPPostingHost()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_NNTP_POSTING_HOST);
    }

    public String getCachePostPath()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_CACHE_POST_PATH);
    }

    public String getXCache()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_X_CACHE);
    }

    public String getXRef()
    {
        return getAttribute(NNTPArticleIfc.ATTR_OP_X_REF);
    }

    public String getPostContent()
    {
        return getAttribute(NNTPArticleIfc.ATTR_POST_CONTENT);
    }


    public void setThreadTab(int tTab)
    {
        _threadTab = tTab;
    }

    public String getThreadTab()
    {
        String s = "";
        for (int i = 0; i < _threadTab; i++)
        {
            s += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        }

        return s;
    }
    
	public int getArticleArrayId()
	{
		return _arrayId;
	}
	
	public void setArticleArrayId(int arrayId)
	{
		_arrayId = arrayId;
	}

    public int compareTo(Object o)
    {
        if(!(o instanceof NNTPArticleIfc))
        {
            return 0;
        }

        NNTPArticleIfc art2 = (NNTPArticleIfc)o;

        if (getReferences().size() > art2.getReferences().size())
        {
            return 1;
        }
        else if (getReferences().size() == art2.getReferences().size())
        {
            return 0;
        }
        else
        {
            return -1;
        }
    }
    
    public void refresh()
    {
    	
    }


	public Map getAttributes()
	{
		return Collections.unmodifiableMap(_attributeMap);
	
	}

}
