/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 16, 2002
 * Time: 11:37:16 AM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.objects;

import com.daveconcannon.nntp.commands.NNTPArticleCommand;
import com.daveconcannon.nntp.commands.NNTPGroupCommand;
import com.daveconcannon.nntp.commands.NNTPPostCommand;

import java.util.Iterator;

public class NNTPArticleFactory
{
	private NNTPArticleCommand _artCommand = null;
	private NNTPGroupCommand _groupCommand = null;
	private NNTPPostCommand _postCommand = null;
    private static NNTPArticleFactory _instance = null;
    

    private NNTPArticleFactory()
    {
		_artCommand = new NNTPArticleCommand();
		_groupCommand = new NNTPGroupCommand();
		_postCommand = new NNTPPostCommand();
    }


    public static NNTPArticleFactory getInstance()
    {
        if (_instance == null)
        {
            _instance = new NNTPArticleFactory();
        }

        return _instance;
    }

	public NNTPArticleIfc createArticle()
	{
		return new NNTPArticle();
	}
	
    public NNTPArticleIfc createArticle(String messageId, NNTPGroupIfc groupToAddTo)
    {
		NNTPGroupIfc currentSelectedGroup = NNTPGroupContainer.getInstance().getCurrentSelectedGroup();
		NNTPArticleIfc article = null;
		synchronized(this)
		{	
			_groupCommand.selectGroup(groupToAddTo);				
			_artCommand.setCommandArguments(messageId);
	
	        boolean successful = _artCommand.sendCommand(_groupCommand);
			
	        if (!successful)
	        {
	            System.out.println("Article Command failed: " + _artCommand.getLastError());
	        }
			_artCommand.processContent();
			_artCommand.returnSocket();
			
			article = (NNTPArticleIfc) _artCommand.getProcessedContent();
	        // Can belong to more than one group.
	        for (Iterator i = article.getGroupNames().iterator(); i.hasNext();)
	        {
	            String name = (String) i.next();
	            NNTPGroupIfc group = NNTPGroupContainer.getInstance().getGroup(name);
	            if (group != null)
	            {
	            	//System.out.println("Adding article: "+article);
	                //group.addArticle(article);
	            }
	        }
		}
		
		_groupCommand.returnSocket();
		
        return article;
        
    }
    
    public synchronized void postArticle(NNTPArticleIfc article, NNTPArticleIfc articleToFollowUpTo, NNTPGroupIfc group)
    {
		if(articleToFollowUpTo != null)
		{
			if(articleToFollowUpTo.getAttribute(NNTPArticleIfc.ATTR_OP_REFERENCES) != null)
			{
				article.setAttribute(NNTPArticleIfc.ATTR_OP_REFERENCES, 
						articleToFollowUpTo.getAttribute(NNTPArticleIfc.ATTR_OP_REFERENCES)+ " " + 
						articleToFollowUpTo.getId());
			}		
			else
			{
				article.setAttribute(NNTPArticleIfc.ATTR_OP_REFERENCES,articleToFollowUpTo.getId());
			}
		}	
		
		postArticle(article, group);
    }
    
    public synchronized void postArticle(NNTPArticleIfc article, NNTPGroupIfc group)
    {
		_postCommand.setCommandArguments(article.getAttributes());
		_postCommand.processContent();
		_postCommand.returnSocket();
		String id = _postCommand.getPostedMessageID();
		group.setNeedsRefresh();
		group.refresh();
		
	}
 }
