/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 16, 2002
 * Time: 11:23:20 AM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.objects;

import java.util.List;
import java.util.Map;

public interface NNTPArticleIfc extends NNTPObjectIfc, Comparable
{
    // Required headers.
    public final static String ATTR_RELAY_VERSION = "Relay-Version";
    public final static String ATTR_POSTING_VERSION = "Posting-Version";
    public final static String ATTR_FROM = "From";
    public final static String ATTR_DATE = "Date";
    public final static String ATTR_NEWSGROUPS = "Newsgroups";
    public final static String ATTR_SUBJECT = "Subject";
    public final static String ATTR_MESG_ID = "Message-ID";
    public final static String ATTR_PATH = "Path";
    public final static String ATTR_LINES = "Lines";

    // Optional headers
    public final static String ATTR_OP_FOLLOWUP_TO = "Followup-To";
    public final static String ATTR_OP_DATE_RECIEVED = "Date-Received";
    public final static String ATTR_OP_EXPIRES = "Expires";
    public final static String ATTR_OP_REPLY_TO = "Reply-To";
    public final static String ATTR_OP_SENDER = "Sender";
    public final static String ATTR_OP_REFERENCES = "References";
    public final static String ATTR_OP_CONTROL = "Control";
    public final static String ATTR_OP_DISTRIBUTION = "Distribution";
    public final static String ATTR_OP_ORGANIZATION = "Organization";
    public final static String ATTR_OP_XTRACE = "X-Trace";
    public final static String ATTR_OP_X_COMPLAINTS_TO = "X-Complaints-To";
    public final static String ATTR_OP_NNTP_POSTING_DATE = "NNTP-Posting-Date";
    public final static String ATTR_OP_NNTP_POSTING_HOST = "NNTP-Posting-Host";
    public final static String ATTR_OP_CACHE_POST_PATH = "Cache-Post-Path";
    public final static String ATTR_OP_X_CACHE = "X-Cache";
    public final static String ATTR_OP_X_REF = "Xref";
    public final static String ATTR_POST_CONTENT = "Post Content";
    public final static String ATTR_SIG = "--";
    
    
	public void setArticleArrayId(int arrayId);
    
    public int getArticleArrayId();
    
    public boolean hasBeenRead();

    public List getReferences();

    public List getGroupNames();

    public String getRelayVersion();

    public String getPostingVersion();

    public String getFrom();

    public String getDate();

    public String getNewsgroups();

    public String getSubject();

    public String getId();

    public String getPath();

    public String getNumberOfLines();

    public String getFollowupTo();

    public String getDateReceived();

    public String getExpires();

    public String getReplyTo();

    public String getSender();

    public String getControl();

    public String getDistribution();

    public String getOrganization();

    public String getXTrace();

    public String getXComplaints();

    public String getNNTPPostingDate();

    public String getNNTPPostingHost();

    public String getCachePostPath();

    public String getXCache();

    public String getXRef();

    public String getPostContent();

    public void setThreadTab(int tTab);

    public String getThreadTab();
    
    public Map getAttributes();
}
