/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 16, 2002
 * Time: 1:25:52 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.objects;

import com.daveconcannon.nntp.util.PostThreadFormatter;

import java.util.*;

public class NNTPGroup extends NNTPObject implements NNTPGroupIfc
{
    private HashMap _articles = null;
    private int _firstArticle = -1;
    private int _lastArticle = -1;
    private boolean _isPostingEnabled = true;
    private List _threadOrderedList = null;
	private NNTPArticleIfc _lastPostedArticle = null;
	
	private static PostThreadFormatter _formatter = new PostThreadFormatter();

    public NNTPGroup(String name)
    {
        super(name);
        _articles = new HashMap();
        setNeedsRefresh();
    }

    public NNTPGroup()
    {
        throw new IllegalStateException("Group must be created by name");
    }

    public synchronized void addArticle(NNTPArticleIfc article)
    {
        _articles.put(article.getId(), article);
        _articles.put(new Integer(article.getArticleArrayId()), article);
		_lastPostedArticle = article;
    }

	public synchronized NNTPArticleIfc getArticle(int messageArrayId)
	{
		if(messageArrayId > getLastArticle())
		{
			System.out.println("Returning null on article size.");
			return null;
		}
		
		Integer intId = new Integer(messageArrayId);
		NNTPArticleIfc article = (NNTPArticleIfc) _articles.get(intId);
		if(article == null)
		{
			if(!_refreshing)
			{
				refresh();
			}
		}
		article = (NNTPArticleIfc) _articles.get(intId);
		return article;	
	}
	
    public synchronized NNTPArticleIfc getArticle(String messageId)
    {
    	NNTPArticleIfc article = (NNTPArticleIfc) _articles.get(messageId);
		if(article == null)
		{
			if(!_refreshing)
			{
				refresh();
			}
		}
		article = (NNTPArticleIfc) _articles.get(messageId);
        return article;
    }
    
    public synchronized NNTPArticleIfc getLastPostedArticle()
    {
    	return _lastPostedArticle;
    }
    
    private boolean _refreshing = false;
	public void refresh()
    {
	   if(needsRefresh())
	   {	
		   synchronized(this)
		   {
			   _refreshing = true;
			   NNTPGroupFactory.getInstance().refreshGroup(this);
				setRefreshed();
			   _refreshing = false;
		   }
	   }
    }

    public synchronized Map getArticles()
    {
        return Collections.unmodifiableMap(_articles);
    }

    public synchronized Collection getArticleList()
    {
        return Collections.unmodifiableCollection(_articles.values());
    }

    public int getNumberOfArticles()
    {
        return _articles.size();
    }

    public int getFirstArticle()
    {
        return _firstArticle;
    }

    public int getLastArticle()
    {
        return _lastArticle;
    }

    public void setFirstArticle(int first)
    {   	
        _firstArticle = first;
    }

    public void setLastArticle(int last)
    {
        _lastArticle = last;
    }

    public boolean isPostingEnabled()
    {
        return _isPostingEnabled;
    }

    public void setPostingEnabled(boolean postingEnabled)
    {
        _isPostingEnabled = postingEnabled;
    }

    public List getThreadOrderedList()
    {        
        _threadOrderedList = _formatter.format(this);
        return _threadOrderedList;
    }
    
	public void setNeedsRefresh()
	{
		super.setNeedsRefresh();
		NNTPGroupContainer.getInstance().setNeedsRefresh();
	}	
}
