/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 16, 2002
 * Time: 1:25:15 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.objects;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import com.daveconcannon.nntp.commands.NNTPListCommand;

public class NNTPGroupContainer extends NNTPObject
{
    // Has groups.
    private static NNTPListCommand _listCommand = null;
    private static NNTPGroupContainer _instance = null;
	private static boolean _refreshing = false;
	private NNTPGroupIfc _currentSelectedGroup = null;
	
    private HashMap _groups = null;

    private NNTPGroupContainer()
    {
        _groups = new HashMap();
		_listCommand = new NNTPListCommand();
		refresh();
    }

    public synchronized HashMap getGroups()
    {
        return _groups;
    }

    public synchronized Collection getGroupList()
    {
        return Collections.unmodifiableCollection(_groups.values());
    }

    public synchronized NNTPGroupIfc getGroup(String groupName)
    {
    	NNTPGroupIfc group = (NNTPGroupIfc) _groups.get(groupName);
		if(group == null)
		{
			if(!_refreshing)
			{
				refresh();
				group = (NNTPGroupIfc) _groups.get(groupName);
			}
		}
		
		if(group != null && group.needsRefresh())
		{
			group.refresh();
		}
				
		group = (NNTPGroupIfc) _groups.get(groupName);
        return group;
    }
    
    public boolean isRefreshing()
    {
    	return _refreshing;
    }
    public void refresh(boolean force)
    {
    	if(force)
    	{
    		setNeedsRefresh();
    	} 
    	
    	refresh();	
    }
    
    public void refresh()
    {
		if(needsRefresh())
		{	
			synchronized(this)
			{
				_refreshing = true;
				_listCommand.sendCommand();
				_listCommand.processContent();
				_refreshing = false;
			}
		}
    }
	
    public synchronized void addGroup(NNTPGroupIfc group)
    {
		_groups.put(group.getName(), group);
    }

    public static NNTPGroupContainer getInstance()
    {
        if (_instance == null)
        {
            _instance = new NNTPGroupContainer();
            _instance.refresh(true);
        }
		
        return _instance;
    }
    
    
    public NNTPGroupIfc getCurrentSelectedGroup()
    {
    	return _currentSelectedGroup;
    }
    
    public void setCurrentSelectedGroup(NNTPGroupIfc currentSelectedGroup)
    {
		_currentSelectedGroup = currentSelectedGroup;
    }
}
