/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 16, 2002
 * Time: 3:31:45 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.objects;

import com.daveconcannon.nntp.commands.NNTPGroupCommand;

public class NNTPGroupFactory
{
    private static NNTPGroupFactory _instance = null;

	private NNTPGroupCommand _groupCommand = null; 
    private NNTPGroupFactory()
    {
		_groupCommand = new NNTPGroupCommand();
    }

    public static NNTPGroupFactory getInstance()
    {
        if (_instance == null)
        {
            _instance = new NNTPGroupFactory();
        }

        return _instance;
    }


	public NNTPGroupIfc newGroup(String name)
	{
		return new NNTPGroup(name);
	}
	
    public NNTPGroupIfc createGroup(String groupName)
    {
        boolean successful = _groupCommand.sendCommand(groupName);

        if (!successful)
        {
            System.out.println("Error creating group: \"" + groupName + "\", " + _groupCommand.getLastError());
            //throw new IllegalStateException("Error creating group: \""+groupName+"\", " +groupCommand.getLastError());
        }

        _groupCommand.processContent();
        NNTPGroupIfc group = (NNTPGroupIfc) _groupCommand.getProcessedContent();
        group.setFullyPopulated(true);
        NNTPGroupContainer.getInstance().addGroup(group);

        return group;
    }
    
    public synchronized void refreshGroup(NNTPGroupIfc group)
    {
    	if(group.needsRefresh())
    	{
			boolean successful = _groupCommand.sendCommand(group.getName());
	
			if (!successful)
			{
				System.out.println("Error creating group: \"" + group.getName() + "\", " + _groupCommand.getLastError());
				//throw new IllegalStateException("Error creating group: \""+groupName+"\", " +groupCommand.getLastError());
			}
	
			_groupCommand.processContent(group);
			group.setFullyPopulated(true);
			group.setRefreshed();
    	}
    }
}
