/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 16, 2002
 * Time: 11:24:39 AM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.objects;

import java.util.Hashtable;

public abstract class NNTPObject implements NNTPObjectIfc
{
    protected Hashtable _attributeMap = null;
    private String _name = null;
    private boolean _isFullyPopulated = false;
    private boolean _needsRefresh = false;

    public NNTPObject(String name)
    {
        setName(name);
        _attributeMap = new Hashtable();
    }

    public NNTPObject()
    {
        this("");
    }

    public void setAttribute(String key, String attribute)
    {
        _attributeMap.put(key, attribute);
    }

    public String getAttribute(String key)
    {
        return (String) _attributeMap.get(key);
    }

    public String getName()
    {
        return _name;
    }

    public void setName(String name)
    {
        _name = name;
    }

    public String toString()
    {
        return getName();
    }

    public boolean isFullyPopulated()
    {
        return _isFullyPopulated;
    }

    public void setFullyPopulated(boolean isFullyPopulated)
    {
        _isFullyPopulated = isFullyPopulated;
    }
    
    public boolean needsRefresh()
    {
    	return _needsRefresh;
    }
    
    public void setNeedsRefresh()
    {
		_needsRefresh = true;    	
    }
    
    public void setRefreshed()
    {
    	_needsRefresh = false;
    }
 }
