/*
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: 05-Jul-02
 * Time: 15:24:55
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package com.daveconcannon.nntp.servlet;

import com.daveconcannon.nntp.objects.NNTPGroupContainer;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.servlet.VelocityServlet;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Date;
import java.util.Properties;
import javax.servlet.http.HttpSession; 
import com.daveconcannon.nntp.io.Logger;


public class NNTPControlServlet extends VelocityServlet
{
    public static String DEFAULT_PAGE = "nntp.htm";
    //public static PrintWriter _logStream = null;
    public static Properties _props = null;
    

    /**
     *  lets override the loadConfiguration() so we can do some
     *  fancier setup of the template path
     */
    protected Properties loadConfiguration(ServletConfig config)
            throws IOException, FileNotFoundException
    {
        String propsFile = config.getInitParameter(INIT_PROPS_KEY);

        String realPath = null;
        if (propsFile != null)
        {
            realPath = getServletContext().getRealPath(propsFile);

            if (realPath != null)
            {
                propsFile = realPath;
            }
        }

		_props = new Properties();
		_props.load(new FileInputStream(propsFile));

        String logPath = _props.getProperty("runtime.log");
        String errorPath = _props.getProperty("error.log");
        DEFAULT_PAGE = _props.getProperty("file.defaultPage");
        
        if(DEFAULT_PAGE == null || "".equals(DEFAULT_PAGE))
        {
        	DEFAULT_PAGE = "nntp.htm";
        }
        
		Logger.getInstance().log("** Logging began at: " + new Date().toString() + " **");
        
        if (logPath != null)
        {
            logPath = getServletContext().getRealPath(logPath);
			_props.setProperty("runtime.log", logPath);
        }

        String path = _props.getProperty("file.resource.loader.path");

        if (path != null)
        {
			NNTPControlUtils.getInstance().setTemplatePrefix(path);
            path = getServletContext().getRealPath(path);
            Logger.getInstance().log("Template path: \""+path+"\"");
			_props.setProperty("file.resource.loader.path", path);
        }

        return _props;
    }


    /**
     * VelocityServlet handles most of the Servlet issues.
     * By extending it, you need to just implement the handleRequest method.
     * @param ctx Context created in VelocityServlet.
     * @return the template
     */
    public Template handleRequest(HttpServletRequest req, HttpServletResponse resp, Context ctx)
    {
        Template template = null;
        String templateName = null;
        boolean exceptionThrown = false;
        
        try
        {
            ctx.put("container", NNTPGroupContainer.getInstance());
            String actionName = req.getParameter(NNTPControlUtils.ACTION_NAME);

            if (actionName == null || "".equals(actionName))
            {
                resp.sendRedirect(DEFAULT_PAGE);
                return template;
            }

			HttpSession session = req.getSession(true);
			
            templateName = NNTPControlUtils.getInstance().getTemplateForAction(actionName);

            if (templateName == null || "".equals(templateName))
            {
                resp.sendRedirect(DEFAULT_PAGE);
                return template;
            }
            
            
        	NNTPControlUtils.getInstance().processContextForAction(actionName, ctx, req);
        	// Get the template
            template = Velocity.getTemplate(templateName);
            
        }
        catch (ResourceNotFoundException rnfe)
        {
			exceptionThrown = true;
			Logger.getInstance().log(rnfe);
			
        }
        catch (ParseErrorException pee)
        {
			exceptionThrown = true;
            Logger.getInstance().log(pee);

        }
        catch (Exception e)
        {
			exceptionThrown = true;
			Logger.getInstance().log(e);
        }
        finally
        {
        	if(exceptionThrown)
        	{
        		try
        		{
					resp.sendRedirect(DEFAULT_PAGE);
        		}
        		catch(Exception e)
        		{
					Logger.getInstance().log(e);
        		}
        	}
        }

		//System.out.println("Returning template: \""+template+"\", name:  \""+templateName+"\"");
        return template;
    }
}
