/*
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: 05-Jul-02
 * Time: 15:32:50
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package com.daveconcannon.nntp.servlet;

import com.daveconcannon.nntp.servlet.actions.NNTPListGroupsAction;
import com.daveconcannon.nntp.servlet.actions.NNTPServletActionIfc;
import com.daveconcannon.nntp.servlet.actions.NNTPViewArticleAction;
import com.daveconcannon.nntp.servlet.actions.NNTPViewGroupsAction;
import com.daveconcannon.nntp.servlet.actions.NNTPPostArticleAction;
import org.apache.velocity.context.Context;

import javax.servlet.http.HttpServletRequest;
import java.util.Hashtable;

public class NNTPControlUtils
{
	
    public static String ACTION_NAME = "action";
    /*public static String ADD_ENTRY = "add";
    public static String MOVE_ENTRY = "move";
    public static String LOGIN_USER = "login";
    public static String CHAT = "chat";
    public static String RUN = "run";
    public static String REMOVE_ENTRY = "remove";
    public static String EDIT_ENTRY = "edit";*/
    public static String VIEW_ARTICLE = "viewArticle";
    public static String VIEW_GROUPS = "viewGroups";
    public static String VIEW_ALL_GROUPS = "viewAllGroups";
    public static String POST_ARTICLE = "postArticle";


    private static String fs = System.getProperty("file.separator");
    //private static String path = ""//fs + "home"+fs+"associat"+fs+"s"+fs+"shimoda"+fs+
    //     "public_html";
    /* private static String ADD_VM = fs + "addEntry.vm";
     private static String REMOVE_VM = fs + "removeEntry.vm";
     private static String EDIT_VM = fs + "editEntry.vm";
     private static String MOVE_VM = fs + "moveEntry.vm";
     private static String LOGIN_VM = fs + "loginUser.vm";
     private static String CHAT_VM = fs + "chat.vm";
     private static String RUN_VM = fs + "runTest.vm";*/

    private static String VIEW_NEWSGROUPS_VM = "viewAllGroups.vm";
    private static String VIEW_ARTICLE_VM = "viewArticle.vm";
    private static String VIEW_GROUPS_VM = "viewGroups.vm";
	private static String POST_ARTICLE_VM = "postArticle.vm";
    


    private Hashtable _actions = null;
    private Hashtable _actionClasses = null;
    private static NNTPControlUtils _instance = null;
    private static String _templateLocationPrefix = "";


    protected NNTPControlUtils()
    {
        _actions = new Hashtable();
        _actionClasses = new Hashtable();
        intializeTemplateMap();
    }


    public static NNTPControlUtils getInstance()
    {
        if (_instance == null)
        {
            _instance = new NNTPControlUtils();
        }

        return _instance;
    }

    public String getTemplateForAction(String action)
    {
        return (String) _actions.get(action);
    }

    public void setTemplatePrefix(String prefix)
    {
        _templateLocationPrefix = prefix;
        intializeTemplateMap();
    }


    private void intializeTemplateMap()
    {
        _actions.clear();
        _actionClasses.clear();
        /*_actions.put(ADD_ENTRY, ADD_VM);
        _actions.put(REMOVE_ENTRY, REMOVE_VM);
        _actions.put(LOGIN_USER, LOGIN_VM);
        _actions.put(CHAT, CHAT_VM);
        _actions.put(RUN, RUN_VM);
        _actions.put(EDIT_ENTRY, EDIT_VM);
        _actions.put(MOVE_ENTRY, MOVE_VM);*/
        
		//_templateLocationPrefix = "template" + fs;

        _actions.put(VIEW_ARTICLE,  VIEW_ARTICLE_VM);
        _actions.put(VIEW_GROUPS,  VIEW_GROUPS_VM);
        _actions.put(VIEW_ALL_GROUPS,   VIEW_NEWSGROUPS_VM);
        _actions.put(POST_ARTICLE,   POST_ARTICLE_VM);

        // Setup class to template mappings.
        _actionClasses.put(VIEW_GROUPS, NNTPViewGroupsAction.class);
        _actionClasses.put(VIEW_ALL_GROUPS, NNTPListGroupsAction.class);
        _actionClasses.put(VIEW_ARTICLE, NNTPViewArticleAction.class);
		_actionClasses.put(POST_ARTICLE, NNTPPostArticleAction.class);
    }

    public void processContextForAction(String action, Context context, HttpServletRequest req)
    {
        Class c = (Class) _actionClasses.get(action);
        if (c != null)
        {
            try
            {
                NNTPServletActionIfc servletAction = (NNTPServletActionIfc) c.newInstance();
                servletAction.action(req, context);
                servletAction = null;
            }
            catch (InstantiationException ie)
            {
            }
            catch (IllegalAccessException ea)
            {
            }
        }
    }  
}
