/*
 * Created on Dec 18, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.daveconcannon.nntp.servlet.actions;


import com.daveconcannon.nntp.objects.NNTPGroupContainer;
import com.daveconcannon.nntp.objects.NNTPArticleFactory;
import com.daveconcannon.nntp.objects.NNTPGroupIfc;
import org.apache.velocity.context.Context;
import javax.servlet.http.HttpServletRequest;
import com.daveconcannon.nntp.objects.NNTPArticleIfc;


/**
 * @author DAVIDCO
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class NNTPPostArticleAction implements NNTPServletActionIfc
{

	public NNTPPostArticleAction()
	{
	}

	public void action(HttpServletRequest req, Context ctx)
	{
		String groupId = req.getParameter("GroupID");
		String articleId = req.getParameter("ArticleID");
		String subject = req.getParameter("subject");
		String user = req.getParameter("user"); 
		String content = req.getParameter("content");
		String submitButton = req.getParameter("sub1");
		
		NNTPGroupContainer groupContainer = NNTPGroupContainer.getInstance();
		NNTPGroupIfc group = groupContainer.getGroup(groupId);
		
		if(submitButton == null || "".equals(submitButton))
		{
			// Form wasn't submitted.
			if(group != null)
			{
				NNTPArticleIfc article = group.getArticle(articleId);
				ctx.put("followUpToArticle", article);
			}
			
			ctx.put("group", group);
			return;
		}
		
		NNTPArticleIfc articleToPost = NNTPArticleFactory.getInstance().createArticle();
		
		if(subject != null)
		{
			articleToPost.setAttribute(NNTPArticleIfc.ATTR_SUBJECT, subject);
		}

		if(user != null)
		{			
			articleToPost.setAttribute(NNTPArticleIfc.ATTR_FROM, user);
		}

		if(groupId != null)
		{
			articleToPost.setAttribute(NNTPArticleIfc.ATTR_NEWSGROUPS, groupId);
		}

		if(content != null)
		{
			articleToPost.setAttribute(NNTPArticleIfc.ATTR_POST_CONTENT, content);
		}
		
		if(articleId != null && !"".equals(articleId))
		{
			NNTPArticleIfc articleToFollowUpTo = group.getArticle(articleId); 
			NNTPArticleFactory.getInstance().postArticle(articleToPost, articleToFollowUpTo, group);
		}
		else
		{
			NNTPArticleFactory.getInstance().postArticle(articleToPost, group);
		}
		
		group.getArticle(articleId);
		ctx.put("group", group);
		ctx.put("article", group.getLastPostedArticle());
	}
}

