package com.daveconcannon.nntp.servlet.actions;

import com.daveconcannon.nntp.objects.NNTPArticleFactory;
import com.daveconcannon.nntp.objects.NNTPArticleIfc;
import com.daveconcannon.nntp.objects.NNTPGroupContainer;
import com.daveconcannon.nntp.objects.NNTPGroupIfc;
import org.apache.velocity.context.Context;

import javax.servlet.http.HttpServletRequest;

public class NNTPViewArticleAction implements NNTPServletActionIfc
{

    public NNTPViewArticleAction()
    {
    }

    public void action(HttpServletRequest req, Context ctx)
    {
        String articleId = req.getParameter("ArticleID");
        String groupId = req.getParameter("GroupID");
        NNTPGroupContainer groupContainer = NNTPGroupContainer.getInstance();
        NNTPGroupIfc group = groupContainer.getGroup(groupId);
        
        
        if (group != null)
        {
            NNTPArticleIfc article = group.getArticle(articleId);
            if (article != null && !article.isFullyPopulated())
            {
                article = NNTPArticleFactory.getInstance().createArticle(articleId, group);
                article.setFullyPopulated(true);
            }

			
		    ctx.put("article", article);
            ctx.put("group", group);
        }
    }
}
