package com.daveconcannon.nntp.servlet.actions;

import com.daveconcannon.nntp.objects.NNTPGroupContainer;
import com.daveconcannon.nntp.objects.NNTPGroupFactory;
import com.daveconcannon.nntp.objects.NNTPGroupIfc;
import org.apache.velocity.context.Context;

import javax.servlet.http.HttpServletRequest;

public class NNTPViewGroupsAction implements NNTPServletActionIfc
{
    public NNTPViewGroupsAction()
    {
    }

    public void action(HttpServletRequest req, Context ctx)
    {
        String requestId = req.getParameter("GroupID");
        NNTPGroupContainer groupContainer = NNTPGroupContainer.getInstance();

        NNTPGroupIfc group = groupContainer.getGroup(requestId);

        if (group == null)
        {
            group = NNTPGroupFactory.getInstance().createGroup(requestId);
        }
        
        ctx.put("group", group);
        ctx.put("format", group.getThreadOrderedList());
    }
}
