/**
 * Created by IntelliJ IDEA.
 * User: dconca
 * Date: Dec 19, 2002
 * Time: 4:46:16 PM
 * To change this template use Options | File Templates.
 */
package com.daveconcannon.nntp.util;

import com.daveconcannon.nntp.objects.NNTPArticleIfc;
import com.daveconcannon.nntp.objects.NNTPGroupIfc;

import java.util.*;

public class PostThreadFormatter
{
    private List _markedArticles = null;

    public PostThreadFormatter()
    {
        _markedArticles = new ArrayList();
    }

    private int _currentRefsSize = 0;

    public List format(NNTPGroupIfc group)
    {
        long time = System.currentTimeMillis();

        Collection articles = group.getArticleList();
        List a = new ArrayList();
        a.addAll(articles);
		//System.out.println("Beginning formatting. There are " + a.size() + " articles.");
        Collections.sort(a);

        List orderedArticles = new ArrayList();

        for (Iterator i = a.iterator(); i.hasNext();)
        {
            NNTPArticleIfc art = (NNTPArticleIfc) i.next();
            if (art.getReferences().size() == 0)
            {
                orderedArticles.addAll(getThreads(art, a));
            }
        }

        for (Iterator i = a.iterator(); i.hasNext();)
        {
            NNTPArticleIfc art = (NNTPArticleIfc) i.next();
            if (!_markedArticles.contains(art))
            {
                orderedArticles.addAll(getThreads(art, a));
            }
        }

		//System.out.println("Formatting took: " + (System.currentTimeMillis() - time));
		_markedArticles.clear();
        return orderedArticles;
    }


    public List getThreads(NNTPArticleIfc currentArticle, List allArticles)
    {
        List returnList = new ArrayList();
        if (_markedArticles.contains(currentArticle))
        {
            return returnList;
        }
        _markedArticles.add(currentArticle);

        returnList.add(currentArticle);
        currentArticle.setThreadTab(_currentRefsSize);

        // Find something that uses this as a ref.
        for (Iterator j = allArticles.iterator(); j.hasNext();)
        {
            NNTPArticleIfc testArticle = (NNTPArticleIfc) j.next();
            List refs = testArticle.getReferences();
            if ((refs.size() == _currentRefsSize + 1) &&
                    (refs.contains(currentArticle.getId())))
            {
                _currentRefsSize++;
                returnList.addAll(getThreads(testArticle, allArticles));
                _currentRefsSize--;
            }
        }

        return returnList;
    }

    class NNTPArticleComparator implements Comparator
    {
        public boolean equals(Object obj)
        {
            return false;
        }

        public int compare(Object o1, Object o2)
        {
            NNTPArticleIfc art1 = (NNTPArticleIfc) o1;
            NNTPArticleIfc art2 = (NNTPArticleIfc) o2;

            if (art1.getReferences().size() > art2.getReferences().size())
            {
                return 1;
            }
            else if (art1.getReferences().size() == art2.getReferences().size())
            {
                return 0;
            }
            else
            {
                return -1;
            }
        }


    }


}
